/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfxml.xmlinput1;

import org.apache.jena.irix.IRIProvider;
import org.apache.jena.irix.SystemIRIx;
import org.apache.jena.rdfxml.xmlinput1.ARPErrorNumbers;

public class ARPOptions
implements ARPErrorNumbers {
    private static int[] defaultErrorMode = new int[400];
    private boolean embedding = false;
    private int[] errorMode = (int[])defaultErrorMode.clone();
    private IRIProvider iriProvider = SystemIRIx.getProvider();

    private ARPOptions() {
    }

    public static ARPOptions createNewOptions() {
        return new ARPOptions();
    }

    public int setErrorMode(int errno, int mode) {
        int old = this.errorMode[errno];
        this.errorMode[errno] = mode;
        return old;
    }

    public void setDefaultErrorMode() {
        this.errorMode = (int[])defaultErrorMode.clone();
    }

    public void setLaxErrorMode() {
        this.setDefaultErrorMode();
        for (int i = 100; i < 200; ++i) {
            this.setErrorMode(i, 0);
        }
    }

    public void setStrictErrorMode() {
        this.setStrictErrorMode(0);
    }

    public void setStrictErrorMode(int nonErrorMode) {
        this.setDefaultErrorMode();
        for (int i = 1; i < 100; ++i) {
            this.setErrorMode(i, nonErrorMode);
        }
        int warning = 1;
        int error = 2;
        switch (nonErrorMode) {
            case 2: {
                warning = 2;
                break;
            }
            case 3: {
                error = 3;
                warning = 3;
            }
        }
        for (int i = 100; i < 200; ++i) {
            this.setErrorMode(i, error);
        }
        this.setErrorMode(117, warning);
        this.setErrorMode(131, warning);
        this.setErrorMode(106, warning);
        this.setErrorMode(119, nonErrorMode);
        this.setErrorMode(114, nonErrorMode);
        this.setErrorMode(113, warning);
        this.setErrorMode(103, warning);
        this.setErrorMode(101, warning);
        this.setErrorMode(118, nonErrorMode);
        this.setErrorMode(135, nonErrorMode);
        this.setErrorMode(126, warning);
    }

    public ARPOptions copy() {
        ARPOptions rslt = new ARPOptions();
        rslt.errorMode = (int[])this.errorMode.clone();
        rslt.embedding = this.embedding;
        return rslt;
    }

    public boolean setEmbedding(boolean embed) {
        boolean old = this.embedding;
        this.embedding = embed;
        return old;
    }

    public int getErrorMode(int eCode) {
        return this.errorMode[eCode];
    }

    public boolean getEmbedding() {
        return this.embedding;
    }

    public void setIRIProvider(IRIProvider f) {
        this.iriProvider = f;
    }

    public IRIProvider getIRIProvider() {
        return this.iriProvider;
    }

    static {
        for (int i = 0; i < defaultErrorMode.length; ++i) {
            ARPOptions.defaultErrorMode[i] = i / 100;
        }
    }
}

