/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.commons.schema.table.TsTableInternalRPCType;
import org.apache.iotdb.commons.schema.table.TsTableInternalRPCUtil;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.schema.DataNodeRegionTaskExecutor;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.mpp.rpc.thrift.TCheckSchemaRegionUsingTemplateReq;
import org.apache.iotdb.mpp.rpc.thrift.TCheckSchemaRegionUsingTemplateResp;
import org.apache.iotdb.mpp.rpc.thrift.TCountPathsUsingTemplateReq;
import org.apache.iotdb.mpp.rpc.thrift.TCountPathsUsingTemplateResp;
import org.apache.iotdb.mpp.rpc.thrift.TUpdateTableReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;

public class SchemaUtils {
    public static boolean checkDataNodeTemplateActivation(ConfigManager configManager, final PathPatternTree patternTree, final Template template) throws MetadataException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            patternTree.serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ByteBuffer patternTreeBytes = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        Map<TConsensusGroupId, TRegionReplicaSet> relatedSchemaRegionGroup = configManager.getRelatedSchemaRegionGroup(patternTree);
        final ArrayList respList = new ArrayList();
        final MetadataException[] exception = new MetadataException[]{null};
        DataNodeRegionTaskExecutor<TCountPathsUsingTemplateReq, TCountPathsUsingTemplateResp> regionTask = new DataNodeRegionTaskExecutor<TCountPathsUsingTemplateReq, TCountPathsUsingTemplateResp>(configManager, relatedSchemaRegionGroup, false, CnToDnAsyncRequestType.COUNT_PATHS_USING_TEMPLATE, (dataNodeLocation, consensusGroupIdList) -> new TCountPathsUsingTemplateReq(template.getId(), patternTreeBytes, consensusGroupIdList)){

            @Override
            protected List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList, TCountPathsUsingTemplateResp response) {
                respList.add(response);
                ArrayList<TConsensusGroupId> failedRegionList = new ArrayList<TConsensusGroupId>();
                if (response.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    return failedRegionList;
                }
                if (response.getStatus().getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    List subStatus = response.getStatus().getSubStatus();
                    for (int i = 0; i < subStatus.size(); ++i) {
                        if (((TSStatus)subStatus.get(i)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                        failedRegionList.add(consensusGroupIdList.get(i));
                    }
                } else {
                    failedRegionList.addAll(consensusGroupIdList);
                }
                return failedRegionList;
            }

            @Override
            protected void onAllReplicasetFailure(TConsensusGroupId consensusGroupId, Set<TDataNodeLocation> dataNodeLocationSet) {
                exception[0] = new MetadataException(String.format("Failed to execute in all replicaset of schemaRegion %s when checking the template %s on %s. Failure nodes: %s", consensusGroupId.id, template, patternTree, dataNodeLocationSet));
                this.interruptTask();
            }
        };
        regionTask.execute();
        if (exception[0] != null) {
            throw exception[0];
        }
        for (TCountPathsUsingTemplateResp resp : respList) {
            if (resp.count <= 0L) continue;
            return true;
        }
        return false;
    }

    public static void checkSchemaRegionUsingTemplate(ConfigManager configManager, final List<PartialPath> deleteDatabasePatternPaths) throws MetadataException {
        PathPatternTree deleteDatabasePatternTree = new PathPatternTree();
        for (PartialPath path : deleteDatabasePatternPaths) {
            deleteDatabasePatternTree.appendPathPattern(path);
        }
        deleteDatabasePatternTree.constructTree();
        Map<TConsensusGroupId, TRegionReplicaSet> relatedSchemaRegionGroup = configManager.getRelatedSchemaRegionGroup(deleteDatabasePatternTree);
        final ArrayList respList = new ArrayList();
        final MetadataException[] exception = new MetadataException[]{null};
        DataNodeRegionTaskExecutor<TCheckSchemaRegionUsingTemplateReq, TCheckSchemaRegionUsingTemplateResp> regionTask = new DataNodeRegionTaskExecutor<TCheckSchemaRegionUsingTemplateReq, TCheckSchemaRegionUsingTemplateResp>(configManager, relatedSchemaRegionGroup, false, CnToDnAsyncRequestType.CHECK_SCHEMA_REGION_USING_TEMPLATE, (dataNodeLocation, consensusGroupIdList) -> new TCheckSchemaRegionUsingTemplateReq(consensusGroupIdList)){

            @Override
            protected List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList, TCheckSchemaRegionUsingTemplateResp response) {
                respList.add(response);
                ArrayList<TConsensusGroupId> failedRegionList = new ArrayList<TConsensusGroupId>();
                if (response.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    return failedRegionList;
                }
                if (response.getStatus().getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    List subStatus = response.getStatus().getSubStatus();
                    for (int i = 0; i < subStatus.size(); ++i) {
                        if (((TSStatus)subStatus.get(i)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                        failedRegionList.add(consensusGroupIdList.get(i));
                    }
                } else {
                    failedRegionList.addAll(consensusGroupIdList);
                }
                return failedRegionList;
            }

            @Override
            protected void onAllReplicasetFailure(TConsensusGroupId consensusGroupId, Set<TDataNodeLocation> dataNodeLocationSet) {
                exception[0] = new MetadataException(String.format("Failed to execute in all replicaset of schemaRegion %s when checking templates on path %s. Failure nodes: %s", consensusGroupId.id, deleteDatabasePatternPaths, dataNodeLocationSet));
                this.interruptTask();
            }
        };
        regionTask.execute();
        if (exception[0] != null) {
            throw exception[0];
        }
        for (TCheckSchemaRegionUsingTemplateResp resp : respList) {
            if (!resp.result) continue;
            throw new PathNotExistException(deleteDatabasePatternPaths.stream().map(PartialPath::getFullPath).collect(Collectors.toList()), false);
        }
    }

    public static Map<Integer, TSStatus> preReleaseTable(String database, TsTable table, ConfigManager configManager, String oldName) {
        TUpdateTableReq req = new TUpdateTableReq();
        req.setType(TsTableInternalRPCType.PRE_UPDATE_TABLE.getOperationType());
        req.setTableInfo(TsTableInternalRPCUtil.serializeSingleTsTableWithDatabase((String)database, (TsTable)table));
        req.setOldName(oldName);
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = configManager.getNodeManager().getRegisteredDataNodeLocations();
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.UPDATE_TABLE, req, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        return clientHandler.getResponseMap().entrySet().stream().filter(entry -> ((TSStatus)entry.getValue()).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<Integer, TSStatus> commitReleaseTable(String database, String tableName, ConfigManager configManager, @Nullable String oldName) {
        TUpdateTableReq req = new TUpdateTableReq();
        req.setType(TsTableInternalRPCType.COMMIT_UPDATE_TABLE.getOperationType());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ReadWriteIOUtils.write((String)database, (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)tableName, (OutputStream)outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        req.setTableInfo(outputStream.toByteArray());
        req.setOldName(oldName);
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = configManager.getNodeManager().getRegisteredDataNodeLocations();
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.UPDATE_TABLE, req, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        return clientHandler.getResponseMap().entrySet().stream().filter(entry -> ((TSStatus)entry.getValue()).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<Integer, TSStatus> rollbackPreRelease(String database, String tableName, ConfigManager configManager, @Nullable String oldName) {
        TUpdateTableReq req = new TUpdateTableReq();
        req.setType(TsTableInternalRPCType.ROLLBACK_UPDATE_TABLE.getOperationType());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ReadWriteIOUtils.write((String)database, (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)tableName, (OutputStream)outputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        req.setTableInfo(outputStream.toByteArray());
        req.setOldName(oldName);
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = configManager.getNodeManager().getRegisteredDataNodeLocations();
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.UPDATE_TABLE, req, dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        return clientHandler.getResponseMap().entrySet().stream().filter(entry -> ((TSStatus)entry.getValue()).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static TSStatus executeInConsensusLayer(ConfigPhysicalPlan plan, ConfigNodeProcedureEnv env, Logger logger) {
        TSStatus status;
        try {
            status = env.getConfigManager().getConsensusManager().write(plan);
        }
        catch (ConsensusException e) {
            logger.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            status = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            status.setMessage(e.getMessage());
        }
        return status;
    }
}

