/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.expression;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.Path;
import org.apache.tsfile.read.expression.IExpression;

public class QueryExpression
implements Serializable {
    private List<Path> selectedSeries = new ArrayList<Path>();
    private List<TSDataType> dataTypes;
    private IExpression expression;
    private boolean hasQueryFilter = false;

    private QueryExpression() {
    }

    public static QueryExpression create() {
        return new QueryExpression();
    }

    public static QueryExpression create(List<Path> selectedSeries, IExpression expression) {
        QueryExpression ret = new QueryExpression();
        ret.selectedSeries = selectedSeries;
        ret.expression = expression;
        ret.hasQueryFilter = expression != null;
        return ret;
    }

    public QueryExpression addSelectedPath(Path path) {
        this.selectedSeries.add(path);
        return this;
    }

    public QueryExpression setSelectSeries(List<Path> selectedSeries) {
        this.selectedSeries = selectedSeries;
        return this;
    }

    public IExpression getExpression() {
        return this.expression;
    }

    public QueryExpression setExpression(IExpression expression) {
        if (expression != null) {
            this.expression = expression;
            this.hasQueryFilter = true;
        }
        return this;
    }

    public List<Path> getSelectedSeries() {
        return this.selectedSeries;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("\n\t[Selected Series]:").append(this.selectedSeries).append("\n\t[TSDataType]:").append(this.dataTypes).append("\n\t[expression]:").append(this.expression);
        return stringBuilder.toString();
    }

    public boolean hasQueryFilter() {
        return this.hasQueryFilter;
    }

    public List<TSDataType> getDataTypes() {
        return this.dataTypes;
    }

    public QueryExpression setDataTypes(List<TSDataType> dataTypes) {
        this.dataTypes = dataTypes;
        return this;
    }
}

