/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.confignode.client.async.CnToDnAsyncRequestType;
import org.apache.iotdb.confignode.client.async.CnToDnInternalServiceAsyncRequestManager;
import org.apache.iotdb.confignode.client.async.handlers.DataNodeAsyncRequestContext;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteLogicalViewPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeEnrichedPlan;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.schema.DataNodeTSStatusTaskExecutor;
import org.apache.iotdb.confignode.procedure.state.schema.DeleteLogicalViewState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.db.exception.metadata.view.ViewNotExistException;
import org.apache.iotdb.mpp.rpc.thrift.TConstructViewSchemaBlackListReq;
import org.apache.iotdb.mpp.rpc.thrift.TDeleteViewSchemaReq;
import org.apache.iotdb.mpp.rpc.thrift.TInvalidateMatchedSchemaCacheReq;
import org.apache.iotdb.mpp.rpc.thrift.TRollbackViewSchemaBlackListReq;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteLogicalViewProcedure
extends StateMachineProcedure<ConfigNodeProcedureEnv, DeleteLogicalViewState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteLogicalViewProcedure.class);
    private String queryId;
    private PathPatternTree patternTree;
    private transient ByteBuffer patternTreeBytes;
    private transient String requestMessage;
    private static final String CONSENSUS_WRITE_ERROR = "Failed in the write API executing the consensus layer due to: ";

    public DeleteLogicalViewProcedure(boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
    }

    public DeleteLogicalViewProcedure(String queryId, PathPatternTree patternTree, boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
        this.queryId = queryId;
        this.setPatternTree(patternTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, DeleteLogicalViewState state) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        try {
            switch (state) {
                case CONSTRUCT_BLACK_LIST: {
                    LOGGER.info("Construct view schemaengine black list of view {}", (Object)this.requestMessage);
                    if (this.constructBlackList(env) > 0L) {
                        this.setNextState(DeleteLogicalViewState.CLEAN_DATANODE_SCHEMA_CACHE);
                        break;
                    }
                    this.setFailure(new ProcedureException((Throwable)new ViewNotExistException(this.patternTree.getAllPathPatterns().stream().map(PartialPath::getFullPath).collect(Collectors.toList()))));
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
                case CLEAN_DATANODE_SCHEMA_CACHE: {
                    LOGGER.info("Invalidate cache of view {}", (Object)this.requestMessage);
                    this.invalidateCache(env);
                    break;
                }
                case DELETE_VIEW_SCHEMA: {
                    LOGGER.info("Delete view schemaengine of {}", (Object)this.requestMessage);
                    this.deleteViewSchema(env);
                    this.collectPayload4Pipe(env);
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
                default: {
                    this.setFailure(new ProcedureException("Unrecognized state " + (Object)((Object)state)));
                    StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.NO_MORE_STATE;
                    return flow;
                }
            }
            StateMachineProcedure.Flow flow = StateMachineProcedure.Flow.HAS_MORE_STATE;
            return flow;
        }
        finally {
            LOGGER.info("DeleteLogicalView-[{}] costs {}ms", (Object)state, (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private long constructBlackList(ConfigNodeProcedureEnv env) {
        Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup = env.getConfigManager().getRelatedSchemaRegionGroup(this.patternTree);
        if (targetSchemaRegionGroup.isEmpty()) {
            return 0L;
        }
        final ArrayList successResult = new ArrayList();
        DeleteLogicalViewRegionTaskExecutor<TConstructViewSchemaBlackListReq> constructBlackListTask = new DeleteLogicalViewRegionTaskExecutor<TConstructViewSchemaBlackListReq>("construct view schema engine black list", env, targetSchemaRegionGroup, CnToDnAsyncRequestType.CONSTRUCT_VIEW_SCHEMA_BLACK_LIST, (dataNodeLocation, consensusGroupIdList) -> new TConstructViewSchemaBlackListReq(consensusGroupIdList, this.patternTreeBytes)){

            @Override
            protected List<TConsensusGroupId> processResponseOfOneDataNode(TDataNodeLocation dataNodeLocation, List<TConsensusGroupId> consensusGroupIdList, TSStatus response) {
                ArrayList<TConsensusGroupId> failedRegionList = new ArrayList<TConsensusGroupId>();
                if (response.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                    successResult.add(response);
                } else if (response.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
                    List subStatusList = response.getSubStatus();
                    for (int i = 0; i < subStatusList.size(); ++i) {
                        if (((TSStatus)subStatusList.get(i)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            successResult.add((TSStatus)subStatusList.get(i));
                            continue;
                        }
                        failedRegionList.add(consensusGroupIdList.get(i));
                    }
                } else {
                    failedRegionList.addAll(consensusGroupIdList);
                }
                return failedRegionList;
            }
        };
        constructBlackListTask.execute();
        if (this.isFailed()) {
            return 0L;
        }
        return successResult.stream().mapToLong(resp -> Long.parseLong(resp.getMessage())).reduce(0L, Long::sum);
    }

    private void invalidateCache(ConfigNodeProcedureEnv env) {
        Map<Integer, TDataNodeLocation> dataNodeLocationMap = env.getConfigManager().getNodeManager().getRegisteredDataNodeLocations();
        DataNodeAsyncRequestContext clientHandler = new DataNodeAsyncRequestContext(CnToDnAsyncRequestType.INVALIDATE_MATCHED_SCHEMA_CACHE, new TInvalidateMatchedSchemaCacheReq(this.patternTreeBytes), dataNodeLocationMap);
        CnToDnInternalServiceAsyncRequestManager.getInstance().sendAsyncRequestWithRetry(clientHandler);
        Map statusMap = clientHandler.getResponseMap();
        for (TSStatus status : statusMap.values()) {
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
            LOGGER.error("Failed to invalidate schemaengine cache of view {}", (Object)this.requestMessage);
            this.setFailure(new ProcedureException(new MetadataException("Invalidate view schemaengine cache failed")));
            return;
        }
        this.setNextState(DeleteLogicalViewState.DELETE_VIEW_SCHEMA);
    }

    private void deleteViewSchema(ConfigNodeProcedureEnv env) {
        DeleteLogicalViewRegionTaskExecutor<TDeleteViewSchemaReq> deleteTimeSeriesTask = new DeleteLogicalViewRegionTaskExecutor<TDeleteViewSchemaReq>("delete view in schema engine", env, env.getConfigManager().getRelatedSchemaRegionGroup(this.patternTree), CnToDnAsyncRequestType.DELETE_VIEW, (dataNodeLocation, consensusGroupIdList) -> new TDeleteViewSchemaReq(consensusGroupIdList, this.patternTreeBytes).setIsGeneratedByPipe(this.isGeneratedByPipe));
        deleteTimeSeriesTask.execute();
    }

    private void collectPayload4Pipe(ConfigNodeProcedureEnv env) {
        TSStatus result;
        try {
            result = env.getConfigManager().getConsensusManager().write(this.isGeneratedByPipe ? new PipeEnrichedPlan(new PipeDeleteLogicalViewPlan(this.patternTreeBytes)) : new PipeDeleteLogicalViewPlan(this.patternTreeBytes));
        }
        catch (ConsensusException e) {
            LOGGER.warn(CONSENSUS_WRITE_ERROR, (Throwable)e);
            result = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            result.setMessage(e.getMessage());
        }
        if (result.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(result.getMessage());
        }
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, DeleteLogicalViewState deleteLogicalViewState) throws IOException, InterruptedException, ProcedureException {
        DeleteLogicalViewRegionTaskExecutor<TRollbackViewSchemaBlackListReq> rollbackStateTask = new DeleteLogicalViewRegionTaskExecutor<TRollbackViewSchemaBlackListReq>("roll back view schema engine black list", env, env.getConfigManager().getRelatedSchemaRegionGroup(this.patternTree), CnToDnAsyncRequestType.ROLLBACK_VIEW_SCHEMA_BLACK_LIST, (dataNodeLocation, consensusGroupIdList) -> new TRollbackViewSchemaBlackListReq(consensusGroupIdList, this.patternTreeBytes));
        rollbackStateTask.execute();
    }

    @Override
    protected boolean isRollbackSupported(DeleteLogicalViewState deleteLogicalViewState) {
        return true;
    }

    @Override
    protected DeleteLogicalViewState getState(int stateId) {
        return DeleteLogicalViewState.values()[stateId];
    }

    @Override
    protected int getStateId(DeleteLogicalViewState deleteLogicalViewState) {
        return deleteLogicalViewState.ordinal();
    }

    @Override
    protected DeleteLogicalViewState getInitialState() {
        return DeleteLogicalViewState.CONSTRUCT_BLACK_LIST;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public PathPatternTree getPatternTree() {
        return this.patternTree;
    }

    public void setPatternTree(PathPatternTree patternTree) {
        this.patternTree = patternTree;
        this.requestMessage = patternTree.getAllPathPatterns().toString();
        this.patternTreeBytes = this.preparePatternTreeBytesData(patternTree);
    }

    private ByteBuffer preparePatternTreeBytesData(PathPatternTree patternTree) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            patternTree.serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.isGeneratedByPipe ? ProcedureType.PIPE_ENRICHED_DELETE_LOGICAL_VIEW_PROCEDURE.getTypeCode() : ProcedureType.DELETE_LOGICAL_VIEW_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.queryId, (OutputStream)stream);
        this.patternTree.serialize(stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.queryId = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.setPatternTree(PathPatternTree.deserialize((ByteBuffer)byteBuffer));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteLogicalViewProcedure that = (DeleteLogicalViewProcedure)o;
        return this.getProcId() == that.getProcId() && ((DeleteLogicalViewState)((Object)this.getCurrentState())).equals(that.getCurrentState()) && this.getCycles() == that.getCycles() && this.isGeneratedByPipe == that.isGeneratedByPipe && this.patternTree.equals((Object)that.patternTree);
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.isGeneratedByPipe, this.patternTree);
    }

    private class DeleteLogicalViewRegionTaskExecutor<Q>
    extends DataNodeTSStatusTaskExecutor<Q> {
        private final String taskName;

        DeleteLogicalViewRegionTaskExecutor(String taskName, ConfigNodeProcedureEnv env, Map<TConsensusGroupId, TRegionReplicaSet> targetSchemaRegionGroup, CnToDnAsyncRequestType dataNodeRequestType, BiFunction<TDataNodeLocation, List<TConsensusGroupId>, Q> dataNodeRequestGenerator) {
            super(env, targetSchemaRegionGroup, false, dataNodeRequestType, dataNodeRequestGenerator);
            this.taskName = taskName;
        }

        @Override
        protected void onAllReplicasetFailure(TConsensusGroupId consensusGroupId, Set<TDataNodeLocation> dataNodeLocationSet) {
            DeleteLogicalViewProcedure.this.setFailure(new ProcedureException(new MetadataException(String.format("Delete view %s failed when [%s] because failed to execute in all replicaset of schemaRegion %s. Failure nodes: %s", DeleteLogicalViewProcedure.this.requestMessage, this.taskName, consensusGroupId.id, dataNodeLocationSet))));
            this.interruptTask();
        }
    }
}

