/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.pipe.payload;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeDeactivateTemplatePlan
extends ConfigPhysicalPlan {
    private Map<PartialPath, List<Template>> templateSetInfo;

    public PipeDeactivateTemplatePlan() {
        super(ConfigPhysicalPlanType.PipeDeactivateTemplate);
    }

    public PipeDeactivateTemplatePlan(Map<PartialPath, List<Template>> templateSetInfo) {
        super(ConfigPhysicalPlanType.PipeDeactivateTemplate);
        this.templateSetInfo = templateSetInfo;
    }

    public Map<PartialPath, List<Template>> getTemplateSetInfo() {
        return this.templateSetInfo;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((int)this.templateSetInfo.size(), (OutputStream)stream);
        for (Map.Entry<PartialPath, List<Template>> entry : this.templateSetInfo.entrySet()) {
            entry.getKey().serialize((OutputStream)stream);
            ReadWriteIOUtils.write((int)entry.getValue().size(), (OutputStream)stream);
            for (Template template : entry.getValue()) {
                template.serialize((OutputStream)stream);
            }
        }
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        int size = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.templateSetInfo = new HashMap<PartialPath, List<Template>>();
        for (int i = 0; i < size; ++i) {
            PartialPath pattern = (PartialPath)PathDeserializeUtil.deserialize((ByteBuffer)buffer);
            int templateNum = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
            ArrayList<Template> templateList = new ArrayList<Template>(templateNum);
            for (int j = 0; j < templateNum; ++j) {
                Template template = new Template();
                template.deserialize(buffer);
                templateList.add(template);
            }
            this.templateSetInfo.put(pattern, templateList);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeDeactivateTemplatePlan that = (PipeDeactivateTemplatePlan)obj;
        return this.templateSetInfo.equals(that.templateSetInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.templateSetInfo);
    }

    public String toString() {
        return "PipeDeactivateTemplatePlan{templateSetInfo='" + this.templateSetInfo + "'}";
    }
}

