/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class SignedSoftwareCertificate
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=344");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=345");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=346");
    private final ByteString certificateData;
    private final ByteString signature;

    public SignedSoftwareCertificate(ByteString certificateData, ByteString signature) {
        this.certificateData = certificateData;
        this.signature = signature;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public ByteString getCertificateData() {
        return this.certificateData;
    }

    public ByteString getSignature() {
        return this.signature;
    }

    protected SignedSoftwareCertificate(SignedSoftwareCertificateBuilder<?, ?> b) {
        super(b);
        this.certificateData = ((SignedSoftwareCertificateBuilder)b).certificateData;
        this.signature = ((SignedSoftwareCertificateBuilder)b).signature;
    }

    public static SignedSoftwareCertificateBuilder<?, ?> builder() {
        return new SignedSoftwareCertificateBuilderImpl();
    }

    public SignedSoftwareCertificateBuilder<?, ?> toBuilder() {
        return new SignedSoftwareCertificateBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignedSoftwareCertificate)) {
            return false;
        }
        SignedSoftwareCertificate other = (SignedSoftwareCertificate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ByteString this$certificateData = this.getCertificateData();
        ByteString other$certificateData = other.getCertificateData();
        if (this$certificateData == null ? other$certificateData != null : !((Object)this$certificateData).equals(other$certificateData)) {
            return false;
        }
        ByteString this$signature = this.getSignature();
        ByteString other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SignedSoftwareCertificate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ByteString $certificateData = this.getCertificateData();
        result = result * 59 + ($certificateData == null ? 43 : ((Object)$certificateData).hashCode());
        ByteString $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SignedSoftwareCertificate(certificateData=" + this.getCertificateData() + ", signature=" + this.getSignature() + ")";
    }

    private static final class SignedSoftwareCertificateBuilderImpl
    extends SignedSoftwareCertificateBuilder<SignedSoftwareCertificate, SignedSoftwareCertificateBuilderImpl> {
        private SignedSoftwareCertificateBuilderImpl() {
        }

        @Override
        protected SignedSoftwareCertificateBuilderImpl self() {
            return this;
        }

        @Override
        public SignedSoftwareCertificate build() {
            return new SignedSoftwareCertificate(this);
        }
    }

    public static abstract class SignedSoftwareCertificateBuilder<C extends SignedSoftwareCertificate, B extends SignedSoftwareCertificateBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ByteString certificateData;
        private ByteString signature;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            SignedSoftwareCertificateBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(SignedSoftwareCertificate instance, SignedSoftwareCertificateBuilder<?, ?> b) {
            b.certificateData(instance.certificateData);
            b.signature(instance.signature);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B certificateData(ByteString certificateData) {
            this.certificateData = certificateData;
            return (B)this.self();
        }

        public B signature(ByteString signature) {
            this.signature = signature;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "SignedSoftwareCertificate.SignedSoftwareCertificateBuilder(super=" + super.toString() + ", certificateData=" + this.certificateData + ", signature=" + this.signature + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<SignedSoftwareCertificate> {
        @Override
        public Class<SignedSoftwareCertificate> getType() {
            return SignedSoftwareCertificate.class;
        }

        @Override
        public SignedSoftwareCertificate decode(SerializationContext context, UaDecoder decoder) {
            ByteString certificateData = decoder.readByteString("CertificateData");
            ByteString signature = decoder.readByteString("Signature");
            return new SignedSoftwareCertificate(certificateData, signature);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, SignedSoftwareCertificate value) {
            encoder.writeByteString("CertificateData", value.getCertificateData());
            encoder.writeByteString("Signature", value.getSignature());
        }
    }
}

