/*
 * Decompiled with CFR 0.152.
 */
package zmq.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.security.SecureRandom;
import zmq.io.net.Address;
import zmq.io.net.tcp.TcpUtils;

public class Utils {
    private static final SecureRandom random = new SecureRandom();

    private Utils() {
    }

    public static int randomInt() {
        return random.nextInt();
    }

    public static byte[] randomBytes(int length2) {
        byte[] bytes = new byte[length2];
        random.nextBytes(bytes);
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findOpenPort() throws IOException {
        try (ServerSocket tmpSocket = new ServerSocket(0, 0);){
            int n = tmpSocket.getLocalPort();
            return n;
        }
    }

    public static void unblockSocket(SelectableChannel ... channels) throws IOException {
        TcpUtils.unblockSocket(channels);
    }

    public static <T> T[] realloc(Class<T> klass, T[] src, int size2, boolean ended) {
        Object[] dest;
        if (size2 > src.length) {
            dest = (Object[])Array.newInstance(klass, size2);
            if (ended) {
                System.arraycopy(src, 0, dest, 0, src.length);
            } else {
                System.arraycopy(src, 0, dest, size2 - src.length, src.length);
            }
        } else if (size2 < src.length) {
            dest = (Object[])Array.newInstance(klass, size2);
            if (ended) {
                System.arraycopy(src, src.length - size2, dest, 0, size2);
            } else {
                System.arraycopy(src, 0, dest, 0, size2);
            }
        } else {
            dest = src;
        }
        return dest;
    }

    public static byte[] bytes(ByteBuffer buf) {
        byte[] d = new byte[buf.limit()];
        buf.get(d);
        return d;
    }

    public static byte[] realloc(byte[] src, int size2) {
        byte[] dest = new byte[size2];
        if (src != null) {
            System.arraycopy(src, 0, dest, 0, src.length);
        }
        return dest;
    }

    public static boolean delete(File path2) {
        File[] files;
        if (!path2.exists()) {
            return false;
        }
        boolean ret = true;
        if (path2.isDirectory() && (files = path2.listFiles()) != null) {
            for (File f2 : files) {
                ret = ret && Utils.delete(f2);
            }
        }
        return ret && path2.delete();
    }

    public static Address getPeerIpAddress(SocketChannel fd) {
        SocketAddress address = fd.socket().getRemoteSocketAddress();
        return new Address(address);
    }

    public static String dump(ByteBuffer buffer2, int pos, int limit2) {
        int oldpos = buffer2.position();
        int oldlimit = buffer2.limit();
        buffer2.limit(limit2).position(pos);
        StringBuilder builder = new StringBuilder("[");
        for (int idx = buffer2.position(); idx < buffer2.limit(); ++idx) {
            builder.append(buffer2.get(idx));
            builder.append(',');
        }
        builder.append(']');
        buffer2.limit(oldlimit).position(oldpos);
        return builder.toString();
    }
}

