/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.objenesis.instantiator.basic;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.springframework.objenesis.ObjenesisException;
import org.springframework.objenesis.instantiator.ObjectInstantiator;
import org.springframework.objenesis.instantiator.annotations.Instantiator;
import org.springframework.objenesis.instantiator.annotations.Typology;
import org.springframework.objenesis.instantiator.util.ClassDefinitionUtils;
import org.springframework.objenesis.instantiator.util.ClassUtils;

@Instantiator(value=Typology.STANDARD)
public class ProxyingInstantiator<T>
implements ObjectInstantiator<T> {
    private static final int INDEX_CLASS_THIS = 1;
    private static final int INDEX_CLASS_SUPERCLASS = 2;
    private static final int INDEX_UTF8_CONSTRUCTOR_NAME = 3;
    private static final int INDEX_UTF8_CONSTRUCTOR_DESC = 4;
    private static final int INDEX_UTF8_CODE_ATTRIBUTE = 5;
    private static final int INDEX_UTF8_CLASS = 7;
    private static final int INDEX_UTF8_SUPERCLASS = 8;
    private static final int CONSTANT_POOL_COUNT = 9;
    private static final byte[] CODE = new byte[]{42, -79};
    private static final int CODE_ATTRIBUTE_LENGTH = 12 + CODE.length;
    private static final String PREFIX = "org.springframework.objenesis.subclasses.";
    private static final String SUFFIX = "$$$Objenesis";
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final String CONSTRUCTOR_DESC = "()V";
    private final Class<? extends T> newType;

    private static String nameForSubclass(Class<?> parent2) {
        String parentName = parent2.getName();
        String subclassName = parentName + SUFFIX;
        if (parentName.startsWith("java.")) {
            subclassName = PREFIX + subclassName;
        }
        return subclassName;
    }

    public ProxyingInstantiator(Class<T> type) {
        ClassLoader loader = type.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        String subclassName = ProxyingInstantiator.nameForSubclass(type);
        byte[] classBytes = ProxyingInstantiator.writeExtendingClass(type, subclassName);
        try {
            this.newType = ClassDefinitionUtils.defineClass(subclassName, classBytes, type, loader);
        }
        catch (Exception e) {
            throw new ObjenesisException(e);
        }
    }

    @Override
    public T newInstance() {
        return ClassUtils.newInstance(this.newType);
    }

    private static byte[] writeExtendingClass(Class<?> type, String subclassName) {
        String parentClazz = ClassUtils.classNameToInternalClassName(type.getName());
        String clazz = ClassUtils.classNameToInternalClassName(subclassName);
        ByteArrayOutputStream bIn = new ByteArrayOutputStream(1000);
        try (DataOutputStream in2 = new DataOutputStream(bIn);){
            in2.write(ClassDefinitionUtils.MAGIC);
            in2.write(ClassDefinitionUtils.VERSION);
            in2.writeShort(9);
            in2.writeByte(7);
            in2.writeShort(7);
            in2.writeByte(7);
            in2.writeShort(8);
            in2.writeByte(1);
            in2.writeUTF(CONSTRUCTOR_NAME);
            in2.writeByte(1);
            in2.writeUTF(CONSTRUCTOR_DESC);
            in2.writeByte(1);
            in2.writeUTF("Code");
            in2.writeByte(1);
            in2.writeUTF("L" + clazz + ";");
            in2.writeByte(1);
            in2.writeUTF(clazz);
            in2.writeByte(1);
            in2.writeUTF(parentClazz);
            in2.writeShort(33);
            in2.writeShort(1);
            in2.writeShort(2);
            in2.writeShort(0);
            in2.writeShort(0);
            in2.writeShort(1);
            in2.writeShort(1);
            in2.writeShort(3);
            in2.writeShort(4);
            in2.writeShort(1);
            in2.writeShort(5);
            in2.writeInt(CODE_ATTRIBUTE_LENGTH);
            in2.writeShort(1);
            in2.writeShort(1);
            in2.writeInt(CODE.length);
            in2.write(CODE);
            in2.writeShort(0);
            in2.writeShort(0);
            in2.writeShort(0);
        }
        catch (IOException e) {
            throw new ObjenesisException(e);
        }
        return bIn.toByteArray();
    }
}

