/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.config;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigLoadingStrategy;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.DefaultConfigLoadingStrategy;
import com.typesafe.config.impl.ConfigImpl;
import com.typesafe.config.impl.Parseable;
import java.io.File;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;

public final class ConfigFactory {
    private static final String STRATEGY_PROPERTY_NAME = "config.strategy";

    private ConfigFactory() {
    }

    public static Config load(String resourceBasename) {
        return ConfigFactory.load(resourceBasename, ConfigParseOptions.defaults(), ConfigResolveOptions.defaults());
    }

    public static Config load(ClassLoader loader, String resourceBasename) {
        return ConfigFactory.load(resourceBasename, ConfigParseOptions.defaults().setClassLoader(loader), ConfigResolveOptions.defaults());
    }

    public static Config load(String resourceBasename, ConfigParseOptions parseOptions, ConfigResolveOptions resolveOptions) {
        ConfigParseOptions withLoader = ConfigFactory.ensureClassLoader(parseOptions, "load");
        Config appConfig = ConfigFactory.parseResourcesAnySyntax(resourceBasename, withLoader);
        return ConfigFactory.load(withLoader.getClassLoader(), appConfig, resolveOptions);
    }

    public static Config load(ClassLoader loader, String resourceBasename, ConfigParseOptions parseOptions, ConfigResolveOptions resolveOptions) {
        return ConfigFactory.load(resourceBasename, parseOptions.setClassLoader(loader), resolveOptions);
    }

    private static ClassLoader checkedContextClassLoader(String methodName) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            throw new ConfigException.BugOrBroken("Context class loader is not set for the current thread; if Thread.currentThread().getContextClassLoader() returns null, you must pass a ClassLoader explicitly to ConfigFactory." + methodName);
        }
        return loader;
    }

    private static ConfigParseOptions ensureClassLoader(ConfigParseOptions options2, String methodName) {
        if (options2.getClassLoader() == null) {
            return options2.setClassLoader(ConfigFactory.checkedContextClassLoader(methodName));
        }
        return options2;
    }

    public static Config load(Config config) {
        return ConfigFactory.load(ConfigFactory.checkedContextClassLoader("load"), config);
    }

    public static Config load(ClassLoader loader, Config config) {
        return ConfigFactory.load(loader, config, ConfigResolveOptions.defaults());
    }

    public static Config load(Config config, ConfigResolveOptions resolveOptions) {
        return ConfigFactory.load(ConfigFactory.checkedContextClassLoader("load"), config, resolveOptions);
    }

    public static Config load(ClassLoader loader, Config config, ConfigResolveOptions resolveOptions) {
        return ConfigFactory.defaultOverrides(loader).withFallback(config).withFallback(ConfigFactory.defaultReference(loader)).resolve(resolveOptions);
    }

    public static Config load() {
        ClassLoader loader = ConfigFactory.checkedContextClassLoader("load");
        return ConfigFactory.load(loader);
    }

    public static Config load(ConfigParseOptions parseOptions) {
        return ConfigFactory.load(parseOptions, ConfigResolveOptions.defaults());
    }

    public static Config load(final ClassLoader loader) {
        final ConfigParseOptions withLoader = ConfigParseOptions.defaults().setClassLoader(loader);
        return ConfigImpl.computeCachedConfig(loader, "load", new Callable<Config>(){

            @Override
            public Config call() {
                return ConfigFactory.load(loader, ConfigFactory.defaultApplication(withLoader));
            }
        });
    }

    public static Config load(ClassLoader loader, ConfigParseOptions parseOptions) {
        return ConfigFactory.load(parseOptions.setClassLoader(loader));
    }

    public static Config load(ClassLoader loader, ConfigResolveOptions resolveOptions) {
        return ConfigFactory.load(loader, ConfigParseOptions.defaults(), resolveOptions);
    }

    public static Config load(ClassLoader loader, ConfigParseOptions parseOptions, ConfigResolveOptions resolveOptions) {
        ConfigParseOptions withLoader = ConfigFactory.ensureClassLoader(parseOptions, "load");
        return ConfigFactory.load(loader, ConfigFactory.defaultApplication(withLoader), resolveOptions);
    }

    public static Config load(ConfigParseOptions parseOptions, ConfigResolveOptions resolveOptions) {
        ConfigParseOptions withLoader = ConfigFactory.ensureClassLoader(parseOptions, "load");
        return ConfigFactory.load(ConfigFactory.defaultApplication(withLoader), resolveOptions);
    }

    public static Config defaultReference() {
        return ConfigFactory.defaultReference(ConfigFactory.checkedContextClassLoader("defaultReference"));
    }

    public static Config defaultReference(ClassLoader loader) {
        return ConfigImpl.defaultReference(loader);
    }

    public static Config defaultOverrides() {
        return ConfigFactory.systemProperties();
    }

    public static Config defaultOverrides(ClassLoader loader) {
        return ConfigFactory.systemProperties();
    }

    public static Config defaultApplication() {
        return ConfigFactory.defaultApplication(ConfigParseOptions.defaults());
    }

    public static Config defaultApplication(ClassLoader loader) {
        return ConfigFactory.defaultApplication(ConfigParseOptions.defaults().setClassLoader(loader));
    }

    public static Config defaultApplication(ConfigParseOptions options2) {
        return ConfigFactory.getConfigLoadingStrategy().parseApplicationConfig(ConfigFactory.ensureClassLoader(options2, "defaultApplication"));
    }

    public static void invalidateCaches() {
        ConfigImpl.reloadSystemPropertiesConfig();
        ConfigImpl.reloadEnvVariablesConfig();
    }

    public static Config empty() {
        return ConfigFactory.empty(null);
    }

    public static Config empty(String originDescription) {
        return ConfigImpl.emptyConfig(originDescription);
    }

    public static Config systemProperties() {
        return ConfigImpl.systemPropertiesAsConfig();
    }

    public static Config systemEnvironment() {
        return ConfigImpl.envVariablesAsConfig();
    }

    public static Config parseProperties(Properties properties, ConfigParseOptions options2) {
        return Parseable.newProperties(properties, options2).parse().toConfig();
    }

    public static Config parseProperties(Properties properties) {
        return ConfigFactory.parseProperties(properties, ConfigParseOptions.defaults());
    }

    public static Config parseReader(Reader reader, ConfigParseOptions options2) {
        return Parseable.newReader(reader, options2).parse().toConfig();
    }

    public static Config parseReader(Reader reader) {
        return ConfigFactory.parseReader(reader, ConfigParseOptions.defaults());
    }

    public static Config parseURL(URL url, ConfigParseOptions options2) {
        return Parseable.newURL(url, options2).parse().toConfig();
    }

    public static Config parseURL(URL url) {
        return ConfigFactory.parseURL(url, ConfigParseOptions.defaults());
    }

    public static Config parseFile(File file2, ConfigParseOptions options2) {
        return Parseable.newFile(file2, options2).parse().toConfig();
    }

    public static Config parseFile(File file2) {
        return ConfigFactory.parseFile(file2, ConfigParseOptions.defaults());
    }

    public static Config parseFileAnySyntax(File fileBasename, ConfigParseOptions options2) {
        return ConfigImpl.parseFileAnySyntax(fileBasename, options2).toConfig();
    }

    public static Config parseFileAnySyntax(File fileBasename) {
        return ConfigFactory.parseFileAnySyntax(fileBasename, ConfigParseOptions.defaults());
    }

    public static Config parseResources(Class<?> klass, String resource, ConfigParseOptions options2) {
        return Parseable.newResources(klass, resource, options2).parse().toConfig();
    }

    public static Config parseResources(Class<?> klass, String resource) {
        return ConfigFactory.parseResources(klass, resource, ConfigParseOptions.defaults());
    }

    public static Config parseResourcesAnySyntax(Class<?> klass, String resourceBasename, ConfigParseOptions options2) {
        return ConfigImpl.parseResourcesAnySyntax(klass, resourceBasename, options2).toConfig();
    }

    public static Config parseResourcesAnySyntax(Class<?> klass, String resourceBasename) {
        return ConfigFactory.parseResourcesAnySyntax(klass, resourceBasename, ConfigParseOptions.defaults());
    }

    public static Config parseResources(ClassLoader loader, String resource, ConfigParseOptions options2) {
        return ConfigFactory.parseResources(resource, options2.setClassLoader(loader));
    }

    public static Config parseResources(ClassLoader loader, String resource) {
        return ConfigFactory.parseResources(loader, resource, ConfigParseOptions.defaults());
    }

    public static Config parseResourcesAnySyntax(ClassLoader loader, String resourceBasename, ConfigParseOptions options2) {
        return ConfigImpl.parseResourcesAnySyntax(resourceBasename, options2.setClassLoader(loader)).toConfig();
    }

    public static Config parseResourcesAnySyntax(ClassLoader loader, String resourceBasename) {
        return ConfigFactory.parseResourcesAnySyntax(loader, resourceBasename, ConfigParseOptions.defaults());
    }

    public static Config parseResources(String resource, ConfigParseOptions options2) {
        ConfigParseOptions withLoader = ConfigFactory.ensureClassLoader(options2, "parseResources");
        return Parseable.newResources(resource, withLoader).parse().toConfig();
    }

    public static Config parseResources(String resource) {
        return ConfigFactory.parseResources(resource, ConfigParseOptions.defaults());
    }

    public static Config parseResourcesAnySyntax(String resourceBasename, ConfigParseOptions options2) {
        return ConfigImpl.parseResourcesAnySyntax(resourceBasename, options2).toConfig();
    }

    public static Config parseResourcesAnySyntax(String resourceBasename) {
        return ConfigFactory.parseResourcesAnySyntax(resourceBasename, ConfigParseOptions.defaults());
    }

    public static Config parseString(String s, ConfigParseOptions options2) {
        return Parseable.newString(s, options2).parse().toConfig();
    }

    public static Config parseString(String s) {
        return ConfigFactory.parseString(s, ConfigParseOptions.defaults());
    }

    public static Config parseMap(Map<String, ? extends Object> values2, String originDescription) {
        return ConfigImpl.fromPathMap(values2, originDescription).toConfig();
    }

    public static Config parseMap(Map<String, ? extends Object> values2) {
        return ConfigFactory.parseMap(values2, null);
    }

    private static ConfigLoadingStrategy getConfigLoadingStrategy() {
        String className = System.getProperties().getProperty(STRATEGY_PROPERTY_NAME);
        if (className != null) {
            try {
                return (ConfigLoadingStrategy)ConfigLoadingStrategy.class.cast(Class.forName(className).newInstance());
            }
            catch (Throwable e) {
                throw new ConfigException.BugOrBroken("Failed to load strategy: " + className, e);
            }
        }
        return new DefaultConfigLoadingStrategy();
    }
}

