/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.client.provider;

import com.alipay.sofa.registry.client.api.Configurator;
import com.alipay.sofa.registry.client.api.Publisher;
import com.alipay.sofa.registry.client.api.Subscriber;
import com.alipay.sofa.registry.client.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RegisterCache {
    private Map<String, Publisher> publisherMap = new ConcurrentHashMap<String, Publisher>();
    private Map<String, Subscriber> subscriberMap = new ConcurrentHashMap<String, Subscriber>();
    private Map<String, Configurator> configuratorMap = new ConcurrentHashMap<String, Configurator>();

    public void addRegister(Publisher publisher) {
        if (null == publisher || StringUtils.isEmpty(publisher.getDataId())) {
            return;
        }
        this.publisherMap.put(publisher.getRegistId(), publisher);
    }

    public void addRegister(Subscriber subscriber) {
        if (null == subscriber || StringUtils.isEmpty(subscriber.getDataId())) {
            return;
        }
        this.subscriberMap.put(subscriber.getRegistId(), subscriber);
    }

    public void addRegister(Configurator configurator) {
        if (null == configurator || StringUtils.isEmpty(configurator.getDataId())) {
            return;
        }
        this.configuratorMap.put(configurator.getRegistId(), configurator);
    }

    public void remove(String registId) {
        if (this.publisherMap.remove(registId) == null && this.subscriberMap.remove(registId) == null) {
            this.configuratorMap.remove(registId);
        }
    }

    public Publisher getPublisherByRegistId(String registId) {
        return this.publisherMap.get(registId);
    }

    public Subscriber getSubscriberByRegistId(String registId) {
        return this.subscriberMap.get(registId);
    }

    public Configurator getConfiguratorByRegistId(String registId) {
        return this.configuratorMap.get(registId);
    }

    public Collection<Publisher> getAllPublishers() {
        return new ArrayList<Publisher>(this.publisherMap.values());
    }

    public Collection<Subscriber> getAllSubscribers() {
        return new ArrayList<Subscriber>(this.subscriberMap.values());
    }

    public Collection<Configurator> getAllConfigurator() {
        return new ArrayList<Configurator>(this.configuratorMap.values());
    }
}

