/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.context;

import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.logging.api.ILog;
import org.apache.skywalking.apm.agent.core.logging.api.LogManager;
import org.apache.skywalking.apm.util.StringUtil;

public class ExtensionContext {
    private static final ILog LOGGER = LogManager.getLogger(ExtensionContext.class);
    private static final String SEPARATOR = "-";
    private static final String PLACEHOLDER = " ";
    private boolean skipAnalysis;
    private Long sendingTimestamp;

    String serialize() {
        String res = this.skipAnalysis ? "1" : "0";
        res = res + SEPARATOR;
        res = res + (Objects.isNull(this.sendingTimestamp) ? PLACEHOLDER : this.sendingTimestamp);
        return res;
    }

    void deserialize(String value) {
        String extensionPart;
        if (StringUtil.isEmpty(value)) {
            return;
        }
        String[] extensionParts = value.split(SEPARATOR);
        if (extensionParts.length > 0) {
            extensionPart = extensionParts[0];
            this.skipAnalysis = Objects.equals(extensionPart, "1");
        }
        if (extensionParts.length > 1 && StringUtil.isNotBlank(extensionPart = extensionParts[1])) {
            try {
                this.sendingTimestamp = Long.parseLong(extensionPart);
            }
            catch (NumberFormatException e) {
                LOGGER.error(e, "the downstream sending timestamp is illegal:[{}]", extensionPart);
            }
        }
    }

    void inject(ContextCarrier carrier) {
        carrier.getExtensionContext().skipAnalysis = this.skipAnalysis;
    }

    void extract(ContextCarrier carrier) {
        this.skipAnalysis = carrier.getExtensionContext().skipAnalysis;
    }

    void handle(AbstractSpan span) {
        if (this.skipAnalysis) {
            span.skipAnalysis();
        }
        if (Objects.nonNull(this.sendingTimestamp)) {
            Tags.TRANSMISSION_LATENCY.set(span, String.valueOf(System.currentTimeMillis() - this.sendingTimestamp));
        }
    }

    public ExtensionContext clone() {
        ExtensionContext context = new ExtensionContext();
        context.skipAnalysis = this.skipAnalysis;
        context.sendingTimestamp = this.sendingTimestamp;
        return context;
    }

    void continued(ContextSnapshot snapshot) {
        this.skipAnalysis = snapshot.getExtensionContext().skipAnalysis;
        this.sendingTimestamp = snapshot.getExtensionContext().sendingTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtensionContext that = (ExtensionContext)o;
        return this.skipAnalysis == that.skipAnalysis && Objects.equals(this.sendingTimestamp, that.sendingTimestamp);
    }

    public int hashCode() {
        return Objects.hash(this.skipAnalysis, this.sendingTimestamp);
    }

    @Generated
    public Long getSendingTimestamp() {
        return this.sendingTimestamp;
    }

    @Generated
    public void setSendingTimestamp(Long sendingTimestamp) {
        this.sendingTimestamp = sendingTimestamp;
    }
}

