/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.storage.redis;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.seata.common.exception.RedisException;
import org.apache.seata.common.util.ConfigTools;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolAbstract;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;

/*
 * Exception performing whole class analysis ignored.
 */
public class JedisPooledFactory {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JedisPooledFactory.class);
    private static volatile JedisPoolAbstract jedisPool = null;
    private static final String HOST = "127.0.0.1";
    private static final int PORT = 6379;
    private static final int DATABASE = 0;
    private static final int SENTINEL_HOST_NUMBER = 3;
    private static final Configuration CONFIGURATION = ConfigurationFactory.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JedisPoolAbstract getJedisPoolInstance(JedisPoolAbstract ... jedisPools) {
        if (jedisPool != null) return jedisPool;
        Class<JedisPooledFactory> clazz = JedisPooledFactory.class;
        synchronized (JedisPooledFactory.class) {
            if (jedisPool != null) return jedisPool;
            JedisPoolAbstract tempJedisPool = null;
            if (jedisPools != null && jedisPools.length > 0) {
                tempJedisPool = jedisPools[0];
            } else {
                String password = CONFIGURATION.getConfig("store.redis.password");
                if (StringUtils.isBlank((String)password)) {
                    password = null;
                } else {
                    String publicKey = CONFIGURATION.getConfig("store.publicKey");
                    if (StringUtils.isNotBlank((String)publicKey)) {
                        try {
                            password = ConfigTools.publicDecrypt((String)password, (String)publicKey);
                        }
                        catch (Exception e) {
                            LOGGER.error("decryption failed,please confirm whether the ciphertext and secret key are correct! error msg: {}", (Object)e.getMessage());
                        }
                    }
                }
                JedisPoolConfig poolConfig = new JedisPoolConfig();
                poolConfig.setMinIdle(CONFIGURATION.getInt("store.redis.minConn", 10));
                poolConfig.setMaxIdle(CONFIGURATION.getInt("store.redis.maxConn", 100));
                poolConfig.setMaxTotal(CONFIGURATION.getInt("store.redis.maxTotal", 100));
                String mode = CONFIGURATION.getConfig("store.redis.mode", "single");
                if (mode.equals("sentinel")) {
                    String masterName = CONFIGURATION.getConfig("store.redis.sentinel.masterName");
                    if (StringUtils.isBlank((String)masterName)) {
                        throw new RedisException("The masterName is null in redis sentinel mode");
                    }
                    HashSet sentinels = new HashSet(3);
                    String[] sentinelHosts = CONFIGURATION.getConfig("store.redis.sentinel.sentinelHosts").split(",");
                    Arrays.asList(sentinelHosts).forEach(sentinelHost -> sentinels.add(sentinelHost));
                    String sentinelPassword = CONFIGURATION.getConfig("store.redis.sentinel.sentinelPassword");
                    if (StringUtils.isBlank((String)sentinelPassword)) {
                        sentinelPassword = null;
                    }
                    tempJedisPool = new JedisSentinelPool(masterName, sentinels, (GenericObjectPoolConfig)poolConfig, 60000, 60000, password, CONFIGURATION.getInt("store.redis.database", 0), null, 2000, 2000, sentinelPassword, null);
                } else {
                    if (!mode.equals("single")) throw new RedisException("Configuration error of redis cluster mode");
                    String host = CONFIGURATION.getConfig("store.redis.single.host");
                    host = StringUtils.isBlank((String)host) ? CONFIGURATION.getConfig("store.redis.host", "127.0.0.1") : host;
                    int port = CONFIGURATION.getInt("store.redis.single.port");
                    port = port == 0 ? CONFIGURATION.getInt("store.redis.port", 6379) : port;
                    tempJedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, 60000, password, CONFIGURATION.getInt("store.redis.database", 0));
                }
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("initialization of the build redis connection pool is complete");
            }
            jedisPool = tempJedisPool;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return jedisPool;
        }
    }

    public static Jedis getJedisInstance() {
        return (Jedis)JedisPooledFactory.getJedisPoolInstance((JedisPoolAbstract[])new JedisPoolAbstract[0]).getResource();
    }
}

