/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.discovery.registry;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.seata.common.metadata.Instance;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.config.ConfigurationFactory;

public interface RegistryService<T> {
    public static final String PREFIX_SERVICE_MAPPING = "vgroupMapping.";
    public static final String PREFIX_SERVICE_ROOT = "service";
    public static final String CONFIG_SPLIT_CHAR = ".";
    public static final Set<String> SERVICE_GROUP_NAME = new HashSet<String>();
    public static final Map<String, Map<String, List<InetSocketAddress>>> CURRENT_ADDRESS_MAP = new ConcurrentHashMap<String, Map<String, List<InetSocketAddress>>>();

    @Deprecated
    public void register(InetSocketAddress var1) throws Exception;

    default public void register(Instance instance) throws Exception {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(instance.getTransaction().getHost(), instance.getTransaction().getPort());
        this.register(inetSocketAddress);
    }

    @Deprecated
    public void unregister(InetSocketAddress var1) throws Exception;

    default public void unregister(Instance instance) throws Exception {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(instance.getTransaction().getHost(), instance.getTransaction().getPort());
        this.unregister(inetSocketAddress);
    }

    public void subscribe(String var1, T var2) throws Exception;

    public void unsubscribe(String var1, T var2) throws Exception;

    public List<InetSocketAddress> lookup(String var1) throws Exception;

    public void close() throws Exception;

    default public String getServiceGroup(String key) {
        key = "service.vgroupMapping." + key;
        if (!SERVICE_GROUP_NAME.contains(key)) {
            SERVICE_GROUP_NAME.add(key);
        }
        return ConfigurationFactory.getInstance().getConfig(key);
    }

    default public List<InetSocketAddress> aliveLookup(String transactionServiceGroup) {
        String clusterName;
        Map clusterAddressMap = CURRENT_ADDRESS_MAP.computeIfAbsent(transactionServiceGroup, k -> new ConcurrentHashMap());
        List inetSocketAddresses = (List)clusterAddressMap.get(clusterName = this.getServiceGroup(transactionServiceGroup));
        if (CollectionUtils.isNotEmpty((Collection)inetSocketAddresses)) {
            return inetSocketAddresses;
        }
        return clusterAddressMap.values().stream().filter(CollectionUtils::isNotEmpty).findAny().orElse(Collections.emptyList());
    }

    default public List<InetSocketAddress> refreshAliveLookup(String transactionServiceGroup, List<InetSocketAddress> aliveAddress) {
        Map clusterAddressMap = CURRENT_ADDRESS_MAP.computeIfAbsent(transactionServiceGroup, key -> new ConcurrentHashMap());
        String clusterName = this.getServiceGroup(transactionServiceGroup);
        return clusterAddressMap.put(clusterName, aliveAddress);
    }

    default public void removeOfflineAddressesIfNecessary(String transactionGroupService, String clusterName, Collection<InetSocketAddress> newAddressed) {
        Map clusterAddressMap = CURRENT_ADDRESS_MAP.computeIfAbsent(transactionGroupService, key -> new ConcurrentHashMap());
        List currentAddresses = clusterAddressMap.getOrDefault(clusterName, Collections.emptyList());
        List inetSocketAddresses = currentAddresses.stream().filter(newAddressed::contains).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(inetSocketAddresses)) {
            clusterAddressMap.put(clusterName, inetSocketAddresses);
        }
    }
}

