/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.properties.bind.AbstractBindHandler;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.origin.Origin;

class ConfigDataLocationBindHandler
extends AbstractBindHandler {
    ConfigDataLocationBindHandler() {
    }

    @Override
    public Object onSuccess(ConfigurationPropertyName name, Bindable<?> target, BindContext context, Object result) {
        if (result instanceof ConfigDataLocation) {
            return this.withOrigin(context, (ConfigDataLocation)result);
        }
        if (result instanceof List) {
            return ((List)result).stream().filter(Objects::nonNull).map(element -> element instanceof ConfigDataLocation ? this.withOrigin(context, (ConfigDataLocation)element) : element).collect(Collectors.toCollection(ArrayList::new));
        }
        if (result instanceof ConfigDataLocation[]) {
            return Arrays.stream((ConfigDataLocation[])result).filter(Objects::nonNull).map(element -> this.withOrigin(context, (ConfigDataLocation)element)).toArray(ConfigDataLocation[]::new);
        }
        return result;
    }

    private ConfigDataLocation withOrigin(BindContext context, ConfigDataLocation result) {
        if (result.getOrigin() != null) {
            return result;
        }
        Origin origin = Origin.from(context.getConfigurationProperty());
        return result.withOrigin(origin);
    }
}

