/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.thriftserver.session;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.livy.JobContext;
import org.apache.livy.thriftserver.session.StatementState;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;

class ThriftSessionState {
    private static String SESSION_STATE_KEY_PREFIX = "livy.sessionState.";
    private static Object CREATE_LOCK = new Object();
    private final JobContext ctx;
    private final SparkSession spark;
    private final String sessionId;
    private final ConcurrentMap<String, StatementState> statements;

    private static String sessionKey(String sessionId) {
        return SESSION_STATE_KEY_PREFIX + sessionId;
    }

    static ThriftSessionState get(JobContext ctx, String sessionId) {
        ThriftSessionState.checkNotNull(sessionId, "No session ID.");
        try {
            return (ThriftSessionState)ctx.getSharedObject(ThriftSessionState.sessionKey(sessionId));
        }
        catch (NoSuchElementException nsee) {
            throw new NoSuchElementException(String.format("Session %s not found.", sessionId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ThriftSessionState create(JobContext ctx, String sessionId) throws Exception {
        ThriftSessionState.checkNotNull(sessionId, "No session ID.");
        String key = ThriftSessionState.sessionKey(sessionId);
        Object object = CREATE_LOCK;
        synchronized (object) {
            try {
                ctx.getSharedObject(key);
                throw new IllegalStateException(String.format("Session %s already exists.", sessionId));
            }
            catch (NoSuchElementException noSuchElementException) {
                ThriftSessionState state = new ThriftSessionState(ctx, sessionId);
                ctx.setSharedObject(key, (Object)state);
                return state;
            }
        }
    }

    private ThriftSessionState(JobContext ctx, String sessionId) throws Exception {
        this.ctx = ctx;
        this.sessionId = sessionId;
        this.statements = new ConcurrentHashMap<String, StatementState>();
        this.spark = ((SparkSession)ctx.sparkSession()).newSession();
    }

    SparkSession spark() {
        return this.spark;
    }

    void registerStatement(String statementId, StructType schema, Iterator<Row> results) {
        ThriftSessionState.checkNotNull(statementId, "No statement ID.");
        StatementState state = new StatementState(schema, results);
        if (this.statements.putIfAbsent(statementId, state) != null) {
            throw new IllegalStateException(String.format("Statement %s already registered.", statementId));
        }
    }

    StatementState findStatement(String statementId) {
        ThriftSessionState.checkNotNull(statementId, "No statement ID.");
        StatementState st = (StatementState)this.statements.get(statementId);
        if (st == null) {
            throw this.statementNotFound(statementId);
        }
        return st;
    }

    void cleanupStatement(String statementId) {
        ThriftSessionState.checkNotNull(statementId, "No statement ID.");
        if (this.statements.remove(statementId) == null) {
            throw this.statementNotFound(statementId);
        }
        this.ctx.sc().cancelJobGroup(statementId);
    }

    void dispose() {
        this.ctx.removeSharedObject(ThriftSessionState.sessionKey(this.sessionId));
    }

    private NoSuchElementException statementNotFound(String statementId) {
        return new NoSuchElementException(String.format("Statement %s not found in session %s.", statementId, this.sessionId));
    }

    private static void checkNotNull(String what, String err) {
        if (what == null) {
            throw new IllegalArgumentException(err);
        }
    }
}

