/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.data.value;

import com.clickhouse.data.ClickHouseValue;
import com.clickhouse.data.ClickHouseValues;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ClickHouseBoolValue
implements ClickHouseValue {
    private static final String ERROR_INVALID_NUMBER = "Boolean value can be only 1(true) or 0(false).";
    private boolean isNull;
    private boolean value;

    public static ClickHouseBoolValue ofNull() {
        return ClickHouseBoolValue.ofNull(null);
    }

    public static ClickHouseBoolValue ofNull(ClickHouseValue ref) {
        return ref instanceof ClickHouseBoolValue ? ((ClickHouseBoolValue)ref).set(true, false) : new ClickHouseBoolValue(true, false);
    }

    public static ClickHouseBoolValue of(boolean value) {
        return ClickHouseBoolValue.of(null, value);
    }

    public static ClickHouseBoolValue of(int value) {
        if (value == 1) {
            return new ClickHouseBoolValue(false, true);
        }
        if (value == 0) {
            return new ClickHouseBoolValue(false, false);
        }
        throw new IllegalArgumentException(ERROR_INVALID_NUMBER);
    }

    public static ClickHouseBoolValue of(ClickHouseValue ref, boolean value) {
        return ref instanceof ClickHouseBoolValue ? ((ClickHouseBoolValue)ref).set(false, value) : new ClickHouseBoolValue(false, value);
    }

    protected ClickHouseBoolValue(boolean isNull, boolean value) {
        this.set(isNull, value);
    }

    protected ClickHouseBoolValue set(boolean isNull, boolean value) {
        this.isNull = isNull;
        this.value = !isNull && value;
        return this;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public ClickHouseBoolValue copy(boolean deep) {
        return new ClickHouseBoolValue(this.isNull, this.value);
    }

    @Override
    public boolean isNullOrEmpty() {
        return this.isNull;
    }

    @Override
    public byte asByte() {
        return this.value ? (byte)1 : 0;
    }

    @Override
    public short asShort() {
        return this.value ? (short)1 : 0;
    }

    @Override
    public int asInteger() {
        return this.value ? 1 : 0;
    }

    @Override
    public long asLong() {
        return this.value ? 1L : 0L;
    }

    @Override
    public BigInteger asBigInteger() {
        if (this.isNull) {
            return null;
        }
        return this.value ? BigInteger.ONE : BigInteger.ZERO;
    }

    @Override
    public float asFloat() {
        return this.value ? 1.0f : 0.0f;
    }

    @Override
    public double asDouble() {
        return this.value ? 1.0 : 0.0;
    }

    @Override
    public BigDecimal asBigDecimal(int scale) {
        if (this.isNull) {
            return null;
        }
        return BigDecimal.valueOf(this.value ? 1L : 0L, scale);
    }

    @Override
    public Object asObject() {
        return this.isNull ? null : Boolean.valueOf(this.value);
    }

    @Override
    public String asString() {
        if (this.isNull) {
            return null;
        }
        return String.valueOf(this.value);
    }

    @Override
    public ClickHouseBoolValue resetToDefault() {
        return this.set(false, false);
    }

    @Override
    public ClickHouseBoolValue resetToNullOrEmpty() {
        return this.set(true, false);
    }

    @Override
    public String toSqlExpression() {
        if (this.isNull) {
            return "NULL";
        }
        return this.value ? "1" : "0";
    }

    @Override
    public ClickHouseBoolValue update(char value) {
        return this.set(false, ClickHouseValues.convertToBoolean(value));
    }

    @Override
    public ClickHouseBoolValue update(byte value) {
        if (value == 1) {
            return this.set(false, true);
        }
        if (value == 0) {
            return this.set(false, false);
        }
        throw new IllegalArgumentException(ERROR_INVALID_NUMBER);
    }

    @Override
    public ClickHouseBoolValue update(short value) {
        if (value == 1) {
            return this.set(false, true);
        }
        if (value == 0) {
            return this.set(false, false);
        }
        throw new IllegalArgumentException(ERROR_INVALID_NUMBER);
    }

    @Override
    public ClickHouseBoolValue update(int value) {
        if (value == 1) {
            return this.set(false, true);
        }
        if (value == 0) {
            return this.set(false, false);
        }
        throw new IllegalArgumentException(ERROR_INVALID_NUMBER);
    }

    @Override
    public ClickHouseBoolValue update(long value) {
        if (value == 1L) {
            return this.set(false, true);
        }
        if (value == 0L) {
            return this.set(false, false);
        }
        throw new IllegalArgumentException(ERROR_INVALID_NUMBER);
    }

    @Override
    public ClickHouseBoolValue update(float value) {
        if (value == 1.0f) {
            return this.set(false, true);
        }
        if (value == 0.0f) {
            return this.set(false, false);
        }
        throw new IllegalArgumentException(ERROR_INVALID_NUMBER);
    }

    @Override
    public ClickHouseBoolValue update(double value) {
        if (value == 1.0) {
            return this.set(false, true);
        }
        if (value == 0.0) {
            return this.set(false, false);
        }
        throw new IllegalArgumentException(ERROR_INVALID_NUMBER);
    }

    @Override
    public ClickHouseBoolValue update(BigInteger value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        if (BigInteger.ONE.equals(value)) {
            return this.set(false, true);
        }
        if (BigInteger.ZERO.equals(value)) {
            return this.set(false, false);
        }
        throw new IllegalArgumentException(ERROR_INVALID_NUMBER);
    }

    @Override
    public ClickHouseBoolValue update(BigDecimal value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        if (BigDecimal.valueOf(1L, value.scale()).equals(value)) {
            return this.set(false, true);
        }
        if (BigDecimal.valueOf(0L, value.scale()).equals(value)) {
            return this.set(false, false);
        }
        throw new IllegalArgumentException(ERROR_INVALID_NUMBER);
    }

    @Override
    public ClickHouseBoolValue update(Enum<?> value) {
        return value == null ? this.resetToNullOrEmpty() : this.update(value.ordinal());
    }

    @Override
    public ClickHouseBoolValue update(String value) {
        if (value == null) {
            return this.resetToNullOrEmpty();
        }
        return this.set(false, ClickHouseValues.convertToBoolean(value));
    }

    @Override
    public ClickHouseBoolValue update(ClickHouseValue value) {
        return value == null || value.isNullOrEmpty() ? this.resetToNullOrEmpty() : this.set(false, value.asBoolean());
    }

    @Override
    public ClickHouseBoolValue update(Object value) {
        if (value instanceof Boolean) {
            return this.set(false, (Boolean)value);
        }
        if (value instanceof Number) {
            return this.update(((Number)value).byteValue());
        }
        if (value instanceof ClickHouseValue) {
            return this.set(false, ((ClickHouseValue)value).asBoolean());
        }
        ClickHouseValue.super.update(value);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ClickHouseBoolValue v = (ClickHouseBoolValue)obj;
        return this.isNull == v.isNull && this.value == v.value;
    }

    public int hashCode() {
        return (31 + (this.isNull ? 1231 : 1237)) * 31 + (this.value ? 1231 : 1237);
    }

    public String toString() {
        return ClickHouseValues.convertToString(this);
    }
}

