/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.system.storedprocdure;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorContext;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorManager;
import org.apache.gravitino.trino.connector.system.storedprocdure.GravitinoStoredProcedure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropCatalogStoredProcedure
extends GravitinoStoredProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(DropCatalogStoredProcedure.class);
    private final CatalogConnectorManager catalogConnectorManager;
    private final String metalake;

    public DropCatalogStoredProcedure(CatalogConnectorManager catalogConnectorManager, String metalake) {
        this.catalogConnectorManager = catalogConnectorManager;
        this.metalake = metalake;
    }

    @Override
    public Procedure createStoredProcedure() throws NoSuchMethodException, IllegalAccessException {
        MethodHandle dropCatalog = MethodHandles.lookup().unreflect(DropCatalogStoredProcedure.class.getMethod("dropCatalog", String.class, Boolean.TYPE)).bindTo(this);
        List<Procedure.Argument> arguments = List.of(new Procedure.Argument("CATALOG", (Type)VarcharType.VARCHAR), new Procedure.Argument("IGNORE_NOT_EXIST", (Type)BooleanType.BOOLEAN, false, (Object)false));
        return new Procedure("system", "drop_catalog", arguments, dropCatalog);
    }

    public void dropCatalog(String catalogName, boolean ignoreNotExist) {
        try {
            CatalogConnectorContext catalogConnector = this.catalogConnectorManager.getCatalogConnector(this.catalogConnectorManager.getTrinoCatalogName(this.metalake, catalogName));
            if (catalogConnector == null) {
                if (ignoreNotExist) {
                    return;
                }
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_CATALOG_NOT_EXISTS, "Catalog " + String.valueOf(NameIdentifier.of((String[])new String[]{this.metalake, catalogName})) + " not exists.");
            }
            catalogConnector.getMetalake().dropCatalog(catalogName, true);
            this.catalogConnectorManager.loadMetalakeSync();
            if (this.catalogConnectorManager.catalogConnectorExist(this.catalogConnectorManager.getTrinoCatalogName(this.metalake, catalogName))) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_OPERATION_FAILED, "Drop catalog failed due to the reloading process fails");
            }
            LOG.info("Drop catalog {} in metalake {} successfully.", (Object)catalogName, (Object)this.metalake);
        }
        catch (NoSuchMetalakeException e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_METALAKE_NOT_EXISTS, "Metalake " + this.metalake + " not exists.");
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_UNSUPPORTED_OPERATION, "Drop catalog failed. " + (StringUtils.isEmpty((CharSequence)e.getMessage()) ? "" : e.getMessage()), (Throwable)e);
        }
    }
}

