/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.utils;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

public class MapUtils {
    private MapUtils() {
    }

    public static Map<String, String> getPrefixMap(Map<String, String> m, String prefix) {
        HashMap configs = Maps.newHashMap();
        m.forEach((k, v) -> {
            if (k.startsWith(prefix)) {
                String newKey = k.substring(prefix.length());
                configs.put(newKey, v);
            }
        });
        return Collections.unmodifiableMap(configs);
    }

    public static Map<String, String> getFilteredMap(Map<String, String> m, Predicate predicate) {
        HashMap configs = Maps.newHashMap();
        m.forEach((k, v) -> {
            if (predicate.test(k)) {
                configs.put(k, v);
            }
        });
        return Collections.unmodifiableMap(configs);
    }

    public static Map<String, String> unmodifiableMap(Map<String, String> m) {
        return Collections.unmodifiableMap(m);
    }
}

