/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HBase", "HDFS", "Hive", "MapReduce", "Pig", "Spark", "YARN"})
@InterfaceStability.Evolving
public class CallerContext {
    public static final Charset SIGNATURE_ENCODING = StandardCharsets.UTF_8;
    public static final String CLIENT_IP_STR = "clientIp";
    public static final String CLIENT_PORT_STR = "clientPort";
    private final String context;
    private final byte[] signature;

    public CallerContext(Builder builder) {
        this.context = builder.context;
        this.signature = builder.signature;
    }

    public String getContext() {
        return this.context;
    }

    public byte[] getSignature() {
        return this.signature == null ? null : Arrays.copyOf(this.signature, this.signature.length);
    }

    @InterfaceAudience.Private
    public boolean isContextValid() {
        return this.context != null && !this.context.isEmpty();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.context).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        CallerContext rhs = (CallerContext)obj;
        return new EqualsBuilder().append((Object)this.context, (Object)rhs.context).append(this.signature, rhs.signature).isEquals();
    }

    public String toString() {
        if (!this.isContextValid()) {
            return "";
        }
        String str = this.context;
        if (this.signature != null) {
            str = str + ":";
            str = str + new String(this.signature, SIGNATURE_ENCODING);
        }
        return str;
    }

    public static CallerContext getCurrent() {
        return CurrentCallerContextHolder.CALLER_CONTEXT.get();
    }

    public static void setCurrent(CallerContext callerContext) {
        CurrentCallerContextHolder.CALLER_CONTEXT.set(callerContext);
    }

    private static final class CurrentCallerContextHolder {
        static final ThreadLocal<CallerContext> CALLER_CONTEXT = new InheritableThreadLocal<CallerContext>();

        private CurrentCallerContextHolder() {
        }
    }

    public static final class Builder {
        public static final String KEY_VALUE_SEPARATOR = ":";
        private final String context;
        private byte[] signature;

        public Builder(String context) {
            this.context = context;
        }

        public Builder setSignature(byte[] signature) {
            if (signature != null && signature.length > 0) {
                this.signature = Arrays.copyOf(signature, signature.length);
            }
            return this;
        }

        public CallerContext build() {
            return new CallerContext(this);
        }
    }
}

