/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lock;

import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.lock.LockType;
import org.apache.gravitino.lock.TreeLockNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeLock {
    public static final Logger LOG = LoggerFactory.getLogger(TreeLock.class);
    private final NameIdentifier identifier;
    private final List<TreeLockNode> lockNodes;
    private final Deque<Pair<TreeLockNode, LockType>> heldLocks = new ConcurrentLinkedDeque<Pair<TreeLockNode, LockType>>();
    private LockType lockType;

    TreeLock(List<TreeLockNode> lockNodes, NameIdentifier identifier) {
        this.lockNodes = lockNodes;
        this.identifier = identifier;
    }

    public void lock(LockType lockType) {
        this.lockType = lockType;
        int length = this.lockNodes.size();
        for (int i = 0; i < length; ++i) {
            TreeLockNode treeLockNode = this.lockNodes.get(i);
            LockType type = i == length - 1 ? lockType : LockType.READ;
            try {
                treeLockNode.lock(type);
                this.heldLocks.push((Pair<TreeLockNode, LockType>)Pair.of((Object)treeLockNode, (Object)((Object)type)));
                treeLockNode.addHoldingThreadTimestamp(Thread.currentThread(), this.identifier, System.currentTimeMillis());
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Node {} has been lock with '{}' lock, hold by {} with ident '{}' at {}", new Object[]{this, lockType, Thread.currentThread(), this.identifier, System.currentTimeMillis()});
                continue;
            }
            catch (Exception e) {
                LOG.error("Failed to lock the treeNode, identifier: {}, node {} of lockNodes: [{}]", new Object[]{this.identifier, treeLockNode, this.lockNodes, e});
                this.unlock();
                throw e;
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Locked the tree lock, ident: {}, lockNodes: [{}], lock type: {}", new Object[]{this.identifier, this.lockNodes, lockType});
        }
    }

    public void unlock() {
        if (this.lockType == null) {
            throw new IllegalStateException("We must lock the tree lock before unlock it.");
        }
        while (!this.heldLocks.isEmpty()) {
            Pair<TreeLockNode, LockType> pair = this.heldLocks.pop();
            TreeLockNode current = (TreeLockNode)pair.getLeft();
            LockType type = (LockType)((Object)pair.getRight());
            current.unlock(type);
            long holdStartTime = current.removeHoldingThreadTimestamp(Thread.currentThread(), this.identifier);
            if (!LOG.isTraceEnabled()) continue;
            LOG.trace("Node {} has been unlock with '{}' lock, hold by {} with ident '{}' for {} ms", new Object[]{this, this.lockType, Thread.currentThread(), this.identifier, System.currentTimeMillis() - holdStartTime});
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Unlocked the tree lock, identifier: {}, lockNodes: [{}], lock type: {}", new Object[]{this.identifier, this.lockNodes, this.lockType});
        }
    }
}

