/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.audit.CallerContext;
import org.apache.gravitino.catalog.FilesetDispatcher;
import org.apache.gravitino.exceptions.FilesetAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchFilesetException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.file.FilesetChange;
import org.apache.gravitino.listener.EventBus;
import org.apache.gravitino.listener.api.event.AlterFilesetEvent;
import org.apache.gravitino.listener.api.event.AlterFilesetFailureEvent;
import org.apache.gravitino.listener.api.event.CreateFilesetEvent;
import org.apache.gravitino.listener.api.event.CreateFilesetFailureEvent;
import org.apache.gravitino.listener.api.event.DropFilesetEvent;
import org.apache.gravitino.listener.api.event.DropFilesetFailureEvent;
import org.apache.gravitino.listener.api.event.GetFileLocationEvent;
import org.apache.gravitino.listener.api.event.GetFileLocationFailureEvent;
import org.apache.gravitino.listener.api.event.ListFilesetEvent;
import org.apache.gravitino.listener.api.event.ListFilesetFailureEvent;
import org.apache.gravitino.listener.api.event.LoadFilesetEvent;
import org.apache.gravitino.listener.api.event.LoadFilesetFailureEvent;
import org.apache.gravitino.listener.api.info.FilesetInfo;
import org.apache.gravitino.utils.PrincipalUtils;

public class FilesetEventDispatcher
implements FilesetDispatcher {
    private final EventBus eventBus;
    private final FilesetDispatcher dispatcher;

    public FilesetEventDispatcher(EventBus eventBus, FilesetDispatcher dispatcher) {
        this.eventBus = eventBus;
        this.dispatcher = dispatcher;
    }

    public NameIdentifier[] listFilesets(Namespace namespace) throws NoSuchSchemaException {
        try {
            NameIdentifier[] nameIdentifiers = this.dispatcher.listFilesets(namespace);
            this.eventBus.dispatchEvent(new ListFilesetEvent(PrincipalUtils.getCurrentUserName(), namespace));
            return nameIdentifiers;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new ListFilesetFailureEvent(PrincipalUtils.getCurrentUserName(), namespace, e));
            throw e;
        }
    }

    public Fileset loadFileset(NameIdentifier ident) throws NoSuchFilesetException {
        try {
            Fileset fileset = this.dispatcher.loadFileset(ident);
            this.eventBus.dispatchEvent(new LoadFilesetEvent(PrincipalUtils.getCurrentUserName(), ident, new FilesetInfo(fileset)));
            return fileset;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new LoadFilesetFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e));
            throw e;
        }
    }

    public Fileset createFileset(NameIdentifier ident, String comment, Fileset.Type type, String storageLocation, Map<String, String> properties) throws NoSuchSchemaException, FilesetAlreadyExistsException {
        try {
            Fileset fileset = this.dispatcher.createFileset(ident, comment, type, storageLocation, properties);
            this.eventBus.dispatchEvent(new CreateFilesetEvent(PrincipalUtils.getCurrentUserName(), ident, new FilesetInfo(fileset)));
            return fileset;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new CreateFilesetFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e, new FilesetInfo(ident.name(), comment, type, storageLocation, properties, null)));
            throw e;
        }
    }

    public Fileset alterFileset(NameIdentifier ident, FilesetChange ... changes) throws NoSuchFilesetException, IllegalArgumentException {
        try {
            Fileset fileset = this.dispatcher.alterFileset(ident, changes);
            this.eventBus.dispatchEvent(new AlterFilesetEvent(PrincipalUtils.getCurrentUserName(), ident, changes, new FilesetInfo(fileset)));
            return fileset;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new AlterFilesetFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e, changes));
            throw e;
        }
    }

    public boolean dropFileset(NameIdentifier ident) {
        try {
            boolean isExists = this.dispatcher.dropFileset(ident);
            this.eventBus.dispatchEvent(new DropFilesetEvent(PrincipalUtils.getCurrentUserName(), ident, isExists));
            return isExists;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new DropFilesetFailureEvent(PrincipalUtils.getCurrentUserName(), ident, e));
            throw e;
        }
    }

    public String getFileLocation(NameIdentifier ident, String subPath) throws NoSuchFilesetException {
        try {
            String actualFileLocation = this.dispatcher.getFileLocation(ident, subPath);
            ImmutableMap.Builder builder = ImmutableMap.builder();
            CallerContext callerContext = CallerContext.CallerContextHolder.get();
            if (callerContext != null && callerContext.context() != null) {
                builder.putAll(callerContext.context());
            }
            this.eventBus.dispatchEvent(new GetFileLocationEvent(PrincipalUtils.getCurrentUserName(), ident, actualFileLocation, subPath, (Map<String, String>)builder.build()));
            return actualFileLocation;
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent(new GetFileLocationFailureEvent(PrincipalUtils.getCurrentUserName(), ident, subPath, e));
            throw e;
        }
    }
}

