/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.gravitino.Audit;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.TableEntity;
import org.apache.gravitino.rel.Column;
import org.apache.gravitino.rel.SupportsPartitions;
import org.apache.gravitino.rel.Table;
import org.apache.gravitino.rel.expressions.distributions.Distribution;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.indexes.Index;

public final class EntityCombinedTable
implements Table {
    private final Table table;
    private final TableEntity tableEntity;
    private Set<String> hiddenProperties;
    private boolean imported;

    private EntityCombinedTable(Table table, TableEntity tableEntity) {
        this.table = table;
        this.tableEntity = tableEntity;
        this.imported = false;
    }

    public static EntityCombinedTable of(Table table, TableEntity tableEntity) {
        return new EntityCombinedTable(table, tableEntity);
    }

    public static EntityCombinedTable of(Table table) {
        return new EntityCombinedTable(table, null);
    }

    public EntityCombinedTable withHiddenPropertiesSet(Set<String> hiddenProperties) {
        this.hiddenProperties = hiddenProperties;
        return this;
    }

    public EntityCombinedTable withImported(boolean imported) {
        this.imported = imported;
        return this;
    }

    public String name() {
        return this.table.name();
    }

    public String comment() {
        return this.table.comment();
    }

    public Column[] columns() {
        return this.table.columns();
    }

    public Map<String, String> properties() {
        return this.table.properties().entrySet().stream().filter(p -> !this.hiddenProperties.contains(p.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public SupportsPartitions supportPartitions() throws UnsupportedOperationException {
        return this.table.supportPartitions();
    }

    public Transform[] partitioning() {
        return this.table.partitioning();
    }

    public SortOrder[] sortOrder() {
        return this.table.sortOrder();
    }

    public Distribution distribution() {
        return this.table.distribution();
    }

    public Index[] index() {
        return this.table.index();
    }

    public boolean imported() {
        return this.imported;
    }

    public Table tableFromCatalog() {
        return this.table;
    }

    public TableEntity tableFromGravitino() {
        return this.tableEntity;
    }

    public Audit auditInfo() {
        AuditInfo mergedAudit = AuditInfo.builder().withCreator(this.table.auditInfo().creator()).withCreateTime(this.table.auditInfo().createTime()).withLastModifier(this.table.auditInfo().lastModifier()).withLastModifiedTime(this.table.auditInfo().lastModifiedTime()).build();
        return this.tableEntity == null ? this.table.auditInfo() : mergedAudit.merge(this.tableEntity.auditInfo(), true);
    }

    StringIdentifier stringIdentifier() {
        return StringIdentifier.fromProperties(this.table.properties());
    }
}

