/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.rel.partitioning;

import java.util.Arrays;
import org.apache.gravitino.dto.rel.ColumnDTO;
import org.apache.gravitino.dto.rel.PartitionUtils;
import org.apache.gravitino.dto.rel.partitioning.Partitioning;
import org.apache.gravitino.dto.rel.partitions.ListPartitionDTO;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.NamedReference;

public final class ListPartitioningDTO
implements Partitioning {
    private final String[][] fieldNames;
    private final ListPartitionDTO[] assignments;

    public static ListPartitioningDTO of(String[][] fieldNames) {
        return ListPartitioningDTO.of(fieldNames, new ListPartitionDTO[0]);
    }

    public static ListPartitioningDTO of(String[][] fieldNames, ListPartitionDTO[] assignments) {
        return new ListPartitioningDTO(fieldNames, assignments);
    }

    private ListPartitioningDTO(String[][] fieldNames, ListPartitionDTO[] assignments) {
        this.fieldNames = fieldNames;
        this.assignments = assignments;
    }

    public String[][] fieldNames() {
        return this.fieldNames;
    }

    public ListPartitionDTO[] assignments() {
        return this.assignments;
    }

    @Override
    public Partitioning.Strategy strategy() {
        return Partitioning.Strategy.LIST;
    }

    @Override
    public void validate(ColumnDTO[] columns) throws IllegalArgumentException {
        Arrays.stream(this.fieldNames).forEach(fieldName -> PartitionUtils.validateFieldExistence(columns, fieldName));
    }

    @Override
    public String name() {
        return this.strategy().name().toLowerCase();
    }

    @Override
    public Expression[] arguments() {
        return (Expression[])Arrays.stream(this.fieldNames).map(NamedReference::field).toArray(Expression[]::new);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListPartitioningDTO)) {
            return false;
        }
        ListPartitioningDTO other = (ListPartitioningDTO)o;
        if (!Arrays.deepEquals((Object[])this.fieldNames, (Object[])other.fieldNames)) {
            return false;
        }
        return Arrays.deepEquals(this.assignments, other.assignments);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode((Object[])this.fieldNames);
        result = result * 59 + Arrays.deepHashCode(this.assignments);
        return result;
    }
}

