/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.iceberg;

import com.google.common.collect.ImmutableSet;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.session.PropertyMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.gravitino.catalog.property.PropertyConverter;
import org.apache.gravitino.rel.expressions.Expression;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.sorts.SortOrders;
import org.apache.gravitino.rel.expressions.transforms.Transform;
import org.apache.gravitino.rel.expressions.transforms.Transforms;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorMetadataAdapter;
import org.apache.gravitino.trino.connector.catalog.iceberg.IcebergDataTypeTransformer;
import org.apache.gravitino.trino.connector.catalog.iceberg.IcebergSchemaPropertyConverter;
import org.apache.gravitino.trino.connector.catalog.iceberg.IcebergTablePropertyConverter;
import org.apache.gravitino.trino.connector.metadata.GravitinoColumn;
import org.apache.gravitino.trino.connector.metadata.GravitinoTable;

public class IcebergMetadataAdapter
extends CatalogConnectorMetadataAdapter {
    private final PropertyConverter tableConverter = new IcebergTablePropertyConverter();
    private final PropertyConverter schemaConverter = new IcebergSchemaPropertyConverter();
    private static final Set<String> ICEBERG_PROPERTIES_TO_REMOVE = ImmutableSet.of((Object)"partitioning", (Object)"sorted_by");

    public IcebergMetadataAdapter(List<PropertyMetadata<?>> schemaProperties, List<PropertyMetadata<?>> tableProperties, List<PropertyMetadata<?>> columnProperties) {
        super(schemaProperties, tableProperties, columnProperties, new IcebergDataTypeTransformer());
    }

    @Override
    public Map<String, Object> toTrinoTableProperties(Map<String, String> properties) {
        Map objectMap = this.tableConverter.gravitinoToEngineProperties(properties);
        return super.toTrinoTableProperties(objectMap);
    }

    @Override
    public Map<String, Object> toTrinoSchemaProperties(Map<String, String> properties) {
        Map objectMap = this.schemaConverter.gravitinoToEngineProperties(properties);
        return super.toTrinoSchemaProperties(objectMap);
    }

    @Override
    public Map<String, String> toGravitinoTableProperties(Map<String, Object> properties) {
        Map stringMap = this.tableConverter.engineToGravitinoProperties(properties);
        return super.toGravitinoTableProperties(stringMap);
    }

    @Override
    public Map<String, String> toGravitinoSchemaProperties(Map<String, Object> properties) {
        Map stringMap = this.schemaConverter.engineToGravitinoProperties(properties);
        return super.toGravitinoSchemaProperties(stringMap);
    }

    @Override
    public GravitinoTable createTable(ConnectorTableMetadata tableMetadata) {
        String tableName = tableMetadata.getTableSchema().getTable().getTableName();
        String schemaName = tableMetadata.getTableSchema().getTable().getSchemaName();
        String comment = tableMetadata.getComment().orElse("");
        Map propertyMap = tableMetadata.getProperties();
        List partitionColumns = propertyMap.containsKey("partitioning") ? (List)propertyMap.get("partitioning") : Collections.emptyList();
        List sortColumns = propertyMap.containsKey("sorted_by") ? (List)propertyMap.get("sorted_by") : Collections.emptyList();
        Map<String, String> properties = this.toGravitinoTableProperties(this.removeKeys(tableMetadata.getProperties(), ICEBERG_PROPERTIES_TO_REMOVE));
        ArrayList<GravitinoColumn> columns = new ArrayList<GravitinoColumn>();
        for (int i = 0; i < tableMetadata.getColumns().size(); ++i) {
            ColumnMetadata column = (ColumnMetadata)tableMetadata.getColumns().get(i);
            columns.add(new GravitinoColumn(column.getName(), this.dataTypeTransformer.getGravitinoType(column.getType()), i, column.getComment(), column.isNullable(), false, column.getProperties()));
        }
        GravitinoTable gravitinoTable = new GravitinoTable(schemaName, tableName, columns, comment, properties);
        if (!partitionColumns.isEmpty()) {
            Transform[] partitioning = (Transform[])partitionColumns.stream().map(Transforms::identity).toArray(Transform[]::new);
            gravitinoTable.setPartitioning(partitioning);
        }
        if (!sortColumns.isEmpty()) {
            SortOrder[] sorting = (SortOrder[])sortColumns.stream().map(sortingColumn -> {
                NamedReference.FieldReference expression = NamedReference.field((String)sortingColumn);
                return SortOrders.ascending((Expression)expression);
            }).toArray(SortOrder[]::new);
            gravitinoTable.setSortOrders(sorting);
        }
        return gravitinoTable;
    }

    @Override
    public ConnectorTableMetadata getTableMetadata(GravitinoTable gravitinoTable) {
        SchemaTableName schemaTableName = new SchemaTableName(gravitinoTable.getSchemaName(), gravitinoTable.getName());
        ArrayList<ColumnMetadata> columnMetadataList = new ArrayList<ColumnMetadata>();
        for (GravitinoColumn column : gravitinoTable.getColumns()) {
            columnMetadataList.add(this.getColumnMetadata(column));
        }
        Map<String, Object> properties = this.toTrinoTableProperties(gravitinoTable.getProperties());
        if (ArrayUtils.isNotEmpty((Object[])gravitinoTable.getPartitioning())) {
            properties.put("partitioning", gravitinoTable.getPartitioning().length > 0 ? Arrays.stream(gravitinoTable.getPartitioning()).map(ts -> ((Transform.SingleFieldTransform)ts).fieldName()[0]).collect(Collectors.toList()) : Collections.emptyList());
        }
        if (ArrayUtils.isNotEmpty((Object[])gravitinoTable.getSortOrders())) {
            properties.put("sorted_by", Arrays.stream(gravitinoTable.getSortOrders()).map(sortOrder -> {
                Expression expression = sortOrder.expression();
                return ((NamedReference)expression).fieldName()[0];
            }).collect(Collectors.toList()));
        }
        return new ConnectorTableMetadata(schemaTableName, columnMetadataList, properties, Optional.ofNullable(gravitinoTable.getComment()));
    }
}

