/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector;

import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.gravitino.trino.connector.GravitinoHandle;
import org.apache.gravitino.trino.connector.GravitinoPredicate;

public class GravitinoConstraint
extends Constraint {
    private final Constraint delegate;

    GravitinoConstraint(Constraint constraint) {
        super(constraint.getSummary());
        this.delegate = constraint;
    }

    public TupleDomain<ColumnHandle> getSummary() {
        return this.delegate.getSummary().transformKeys(GravitinoHandle::unWrap);
    }

    public ConnectorExpression getExpression() {
        return this.delegate.getExpression();
    }

    public Map<String, ColumnHandle> getAssignments() {
        return GravitinoHandle.unWrap(this.delegate.getAssignments());
    }

    public Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate() {
        return this.delegate.predicate().map(GravitinoPredicate::new);
    }

    public Optional<Set<ColumnHandle>> getPredicateColumns() {
        return this.delegate.getPredicateColumns().map(result -> result.stream().map(GravitinoHandle::unWrap).collect(Collectors.toSet()));
    }

    public String toString() {
        return this.delegate.toString();
    }
}

