/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import java.util.List;
import org.apache.gravitino.storage.relational.po.TopicPO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface TopicMetaMapper {
    public static final String TABLE_NAME = "topic_meta";

    @Insert(value={"INSERT INTO topic_meta(topic_id, topic_name, metalake_id, catalog_id, schema_id, comment, properties, audit_info, current_version, last_version, deleted_at) VALUES( #{topicMeta.topicId}, #{topicMeta.topicName}, #{topicMeta.metalakeId}, #{topicMeta.catalogId}, #{topicMeta.schemaId}, #{topicMeta.comment}, #{topicMeta.properties}, #{topicMeta.auditInfo}, #{topicMeta.currentVersion}, #{topicMeta.lastVersion}, #{topicMeta.deletedAt} )"})
    public void insertTopicMeta(@Param(value="topicMeta") TopicPO var1);

    @Insert(value={"INSERT INTO topic_meta(topic_id, topic_name, metalake_id, catalog_id, schema_id, comment, properties, audit_info, current_version, last_version, deleted_at) VALUES( #{topicMeta.topicId}, #{topicMeta.topicName}, #{topicMeta.metalakeId}, #{topicMeta.catalogId}, #{topicMeta.schemaId}, #{topicMeta.comment}, #{topicMeta.properties}, #{topicMeta.auditInfo}, #{topicMeta.currentVersion}, #{topicMeta.lastVersion}, #{topicMeta.deletedAt} ) ON DUPLICATE KEY UPDATE topic_name = #{topicMeta.topicName}, metalake_id = #{topicMeta.metalakeId}, catalog_id = #{topicMeta.catalogId}, schema_id = #{topicMeta.schemaId}, comment = #{topicMeta.comment}, properties = #{topicMeta.properties}, audit_info = #{topicMeta.auditInfo}, current_version = #{topicMeta.currentVersion}, last_version = #{topicMeta.lastVersion}, deleted_at = #{topicMeta.deletedAt}"})
    public void insertTopicMetaOnDuplicateKeyUpdate(@Param(value="topicMeta") TopicPO var1);

    @Select(value={"SELECT topic_id as topicId, topic_name as topicName, metalake_id as metalakeId, catalog_id as catalogId, schema_id as schemaId, comment as comment, properties as properties, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM topic_meta WHERE schema_id = #{schemaId} AND deleted_at = 0"})
    public List<TopicPO> listTopicPOsBySchemaId(@Param(value="schemaId") Long var1);

    @Select(value={"SELECT topic_id as topicId, topic_name as topicName, metalake_id as metalakeId, catalog_id as catalogId, schema_id as schemaId, comment as comment, properties as properties, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM topic_meta WHERE schema_id = #{schemaId} AND topic_name = #{topicName} AND deleted_at = 0"})
    public TopicPO selectTopicMetaBySchemaIdAndName(@Param(value="schemaId") Long var1, @Param(value="topicName") String var2);

    @Select(value={"SELECT topic_id as topicId, topic_name as topicName, metalake_id as metalakeId, catalog_id as catalogId, schema_id as schemaId, comment as comment, properties as properties, audit_info as auditInfo, current_version as currentVersion, last_version as lastVersion, deleted_at as deletedAt FROM topic_meta WHERE topic_id = #{topicId} AND deleted_at = 0"})
    public TopicPO selectTopicMetaById(@Param(value="topicId") Long var1);

    @Update(value={"UPDATE topic_meta SET topic_name = #{newTopicMeta.topicName}, metalake_id = #{newTopicMeta.metalakeId}, catalog_id = #{newTopicMeta.catalogId}, schema_id = #{newTopicMeta.schemaId}, comment = #{newTopicMeta.comment}, properties = #{newTopicMeta.properties}, audit_info = #{newTopicMeta.auditInfo}, current_version = #{newTopicMeta.currentVersion}, last_version = #{newTopicMeta.lastVersion}, deleted_at = #{newTopicMeta.deletedAt} WHERE topic_id = #{oldTopicMeta.topicId} AND topic_name = #{oldTopicMeta.topicName} AND metalake_id = #{oldTopicMeta.metalakeId} AND catalog_id = #{oldTopicMeta.catalogId} AND schema_id = #{oldTopicMeta.schemaId} AND comment = #{oldTopicMeta.comment} AND properties = #{oldTopicMeta.properties} AND audit_info = #{oldTopicMeta.auditInfo} AND current_version = #{oldTopicMeta.currentVersion} AND last_version = #{oldTopicMeta.lastVersion} AND deleted_at = 0"})
    public Integer updateTopicMeta(@Param(value="newTopicMeta") TopicPO var1, @Param(value="oldTopicMeta") TopicPO var2);

    @Select(value={"SELECT topic_id as topicId FROM topic_meta WHERE schema_id = #{schemaId} AND topic_name = #{topicName} AND deleted_at = 0"})
    public Long selectTopicIdBySchemaIdAndName(@Param(value="schemaId") Long var1, @Param(value="topicName") String var2);

    @Update(value={"UPDATE topic_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE topic_id = #{topicId} AND deleted_at = 0"})
    public Integer softDeleteTopicMetasByTopicId(@Param(value="topicId") Long var1);

    @Update(value={"UPDATE topic_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE catalog_id = #{catalogId} AND deleted_at = 0"})
    public Integer softDeleteTopicMetasByCatalogId(@Param(value="catalogId") Long var1);

    @Update(value={"UPDATE topic_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE metalake_id = #{metalakeId} AND deleted_at = 0"})
    public Integer softDeleteTopicMetasByMetalakeId(@Param(value="metalakeId") Long var1);

    @Update(value={"UPDATE topic_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE schema_id = #{schemaId} AND deleted_at = 0"})
    public Integer softDeleteTopicMetasBySchemaId(@Param(value="schemaId") Long var1);

    @Delete(value={"DELETE FROM topic_meta WHERE deleted_at != 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}"})
    public Integer deleteTopicMetasByLegacyTimeline(@Param(value="legacyTimeline") Long var1, @Param(value="limit") int var2);
}

