/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.kv;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.storage.kv.KvBackend;
import org.apache.gravitino.storage.kv.KvRange;
import org.apache.gravitino.utils.ByteUtils;
import org.apache.gravitino.utils.Bytes;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBKvBackend
implements KvBackend {
    public static final Logger LOGGER = LoggerFactory.getLogger(RocksDBKvBackend.class);
    private RocksDB db;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RocksDB initRocksDB(Config config) throws RocksDBException {
        RocksDB.loadLibrary();
        String dbPath = this.getStoragePath(config);
        File dbDir = new File(dbPath, "instance");
        try (Options options = new Options();){
            options.setCreateIfMissing(true);
            if (!dbDir.exists() && !dbDir.mkdirs()) {
                throw new RocksDBException(String.format("Can't create RocksDB path '%s'", dbDir.getAbsolutePath()));
            }
            LOGGER.info("Rocksdb storage directory:{}", (Object)dbDir);
            RocksDB rocksDB = RocksDB.open((Options)options, (String)dbDir.getAbsolutePath());
            return rocksDB;
        }
        catch (RocksDBException ex) {
            LOGGER.error("Error initializing RocksDB, check configurations and permissions, exception: {}, message: {}, stackTrace: {}", new Object[]{ex.getCause(), ex.getMessage(), ex.getStackTrace()});
            throw ex;
        }
    }

    @VisibleForTesting
    String getStoragePath(Config config) {
        String dbPath = config.get(Configs.ENTITY_KV_ROCKSDB_BACKEND_PATH);
        if (StringUtils.isBlank((CharSequence)dbPath)) {
            return Configs.DEFAULT_KV_ROCKSDB_BACKEND_PATH;
        }
        Path path = Paths.get(dbPath, new String[0]);
        if (!path.isAbsolute()) {
            path = Paths.get(System.getenv("GRAVITINO_HOME"), dbPath);
            return path.toString();
        }
        return dbPath;
    }

    @Override
    public void initialize(Config config) throws IOException {
        try {
            this.db = this.initRocksDB(config);
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void put(byte[] key, byte[] value, boolean overwrite) throws IOException {
        try {
            this.handlePut(key, value, overwrite);
        }
        catch (EntityAlreadyExistsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @VisibleForTesting
    void handlePut(byte[] key, byte[] value, boolean overwrite) throws RocksDBException {
        if (overwrite) {
            this.db.put(key, value);
            return;
        }
        byte[] existKey = this.db.get(key);
        if (existKey != null) {
            throw new EntityAlreadyExistsException("Key %s already exists in the database, please use overwrite option to overwrite it", ByteUtils.formatByteArray(key));
        }
        this.db.put(key, value);
    }

    @Override
    public byte[] get(byte[] key) throws IOException {
        try {
            return this.db.get(key);
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Pair<byte[], byte[]>> scan(KvRange scanRange) throws IOException {
        try (RocksIterator rocksIterator = this.db.newIterator();){
            byte[] key;
            rocksIterator.seek(scanRange.getStart());
            ArrayList result = Lists.newArrayList();
            int count = 0;
            while (count < scanRange.getLimit() && rocksIterator.isValid() && Bytes.wrap(key = rocksIterator.key()).compareTo(scanRange.getEnd()) <= 0) {
                if (!scanRange.getPredicate().test(key, rocksIterator.value())) {
                    rocksIterator.next();
                    continue;
                }
                if (Bytes.wrap(key).compareTo(scanRange.getStart()) == 0) {
                    if (scanRange.isStartInclusive()) {
                        result.add(Pair.of((Object)key, (Object)rocksIterator.value()));
                        ++count;
                    }
                } else {
                    if (Bytes.wrap(key).compareTo(scanRange.getEnd()) == 0) {
                        if (!scanRange.isEndInclusive()) break;
                        result.add(Pair.of((Object)key, (Object)rocksIterator.value()));
                        break;
                    }
                    result.add(Pair.of((Object)key, (Object)rocksIterator.value()));
                    ++count;
                }
                rocksIterator.next();
            }
            ArrayList arrayList = result;
            return arrayList;
        }
    }

    @Override
    public boolean delete(byte[] key) throws IOException {
        try {
            this.db.delete(key);
            return true;
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteRange(KvRange deleteRange) throws IOException {
        try (RocksIterator rocksIterator = this.db.newIterator();){
            byte[] key;
            rocksIterator.seek(deleteRange.getStart());
            while (rocksIterator.isValid() && Bytes.wrap(key = rocksIterator.key()).compareTo(deleteRange.getEnd()) <= 0) {
                if (Bytes.wrap(key).compareTo(deleteRange.getStart()) == 0) {
                    if (deleteRange.isStartInclusive()) {
                        this.delete(key);
                    }
                } else {
                    if (Bytes.wrap(key).compareTo(deleteRange.getEnd()) == 0) {
                        if (!deleteRange.isEndInclusive()) break;
                        this.delete(key);
                        break;
                    }
                    this.delete(key);
                }
                rocksIterator.next();
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void close() throws IOException {
        this.db.close();
    }

    @VisibleForTesting
    public RocksDB getDb() {
        return this.db;
    }

    @VisibleForTesting
    public void setDb(RocksDB db) {
        this.db = db;
    }
}

