/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.proto;

import org.apache.gravitino.Catalog;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.CatalogEntity;
import org.apache.gravitino.proto.AuditInfoSerDe;
import org.apache.gravitino.proto.Catalog;
import org.apache.gravitino.proto.ProtoSerDe;

public class CatalogEntitySerDe
implements ProtoSerDe<CatalogEntity, Catalog> {
    @Override
    public Catalog serialize(CatalogEntity catalogEntity) {
        Catalog.Builder builder = Catalog.newBuilder().setId(catalogEntity.id().longValue()).setName(catalogEntity.name()).setProvider(catalogEntity.getProvider()).setAuditInfo(new AuditInfoSerDe().serialize((AuditInfo)catalogEntity.auditInfo()));
        if (catalogEntity.getComment() != null) {
            builder.setComment(catalogEntity.getComment());
        }
        if (catalogEntity.getProperties() != null && !catalogEntity.getProperties().isEmpty()) {
            builder.putAllProperties(catalogEntity.getProperties());
        }
        Catalog.Type type = Catalog.Type.valueOf((String)catalogEntity.getType().name());
        builder.setType(type);
        return builder.build();
    }

    @Override
    public CatalogEntity deserialize(Catalog p, Namespace namespace) {
        CatalogEntity.Builder builder = CatalogEntity.builder();
        builder.withId(p.getId()).withName(p.getName()).withNamespace(namespace).withProvider(p.getProvider()).withAuditInfo(new AuditInfoSerDe().deserialize(p.getAuditInfo(), namespace));
        if (p.hasComment()) {
            builder.withComment(p.getComment());
        }
        if (p.getPropertiesCount() > 0) {
            builder.withProperties(p.getPropertiesMap());
        }
        builder.withType(Catalog.Type.valueOf((String)p.getType().name()));
        return builder.build();
    }
}

