/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.connector.BaseCatalog;
import org.apache.gravitino.connector.authorization.AuthorizationPlugin;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationUtils {
    static final String USER_DOES_NOT_EXIST_MSG = "User %s does not exist in th metalake %s";
    static final String GROUP_DOES_NOT_EXIST_MSG = "Group %s does not exist in th metalake %s";
    static final String ROLE_DOES_NOT_EXIST_MSG = "Role %s does not exist in th metalake %s";
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationUtils.class);
    private static final String METALAKE_DOES_NOT_EXIST_MSG = "Metalake %s does not exist";
    private static final List<Privilege.Name> pluginNotSupportsPrivileges = Lists.newArrayList((Object[])new Privilege.Name[]{Privilege.Name.CREATE_CATALOG, Privilege.Name.USE_CATALOG, Privilege.Name.MANAGE_GRANTS, Privilege.Name.MANAGE_USERS, Privilege.Name.MANAGE_GROUPS, Privilege.Name.CREATE_ROLE});

    private AuthorizationUtils() {
    }

    static void checkMetalakeExists(String metalake) throws NoSuchMetalakeException {
        try {
            EntityStore store = GravitinoEnv.getInstance().entityStore();
            NameIdentifier metalakeIdent = NameIdentifier.of((String[])new String[]{metalake});
            if (!store.exists(metalakeIdent, Entity.EntityType.METALAKE)) {
                LOG.warn("Metalake {} does not exist", (Object)metalakeIdent);
                throw new NoSuchMetalakeException(METALAKE_DOES_NOT_EXIST_MSG, new Object[]{metalakeIdent});
            }
        }
        catch (IOException e) {
            LOG.error("Failed to do storage operation", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static NameIdentifier ofRole(String metalake, String role) {
        return NameIdentifier.of((String[])new String[]{metalake, "system", "role", role});
    }

    public static NameIdentifier ofGroup(String metalake, String group) {
        return NameIdentifier.of((String[])new String[]{metalake, "system", "group", group});
    }

    public static NameIdentifier ofUser(String metalake, String user) {
        return NameIdentifier.of((String[])new String[]{metalake, "system", "user", user});
    }

    public static Namespace ofRoleNamespace(String metalake) {
        return Namespace.of((String[])new String[]{metalake, "system", "role"});
    }

    public static Namespace ofGroupNamespace(String metalake) {
        return Namespace.of((String[])new String[]{metalake, "system", "group"});
    }

    public static Namespace ofUserNamespace(String metalake) {
        return Namespace.of((String[])new String[]{metalake, "system", "user"});
    }

    public static void checkUser(NameIdentifier ident) {
        NameIdentifier.check((ident != null ? 1 : 0) != 0, (String)"User identifier must not be null", (Object[])new Object[0]);
        AuthorizationUtils.checkUserNamespace(ident.namespace());
    }

    public static void checkGroup(NameIdentifier ident) {
        NameIdentifier.check((ident != null ? 1 : 0) != 0, (String)"Group identifier must not be null", (Object[])new Object[0]);
        AuthorizationUtils.checkGroupNamespace(ident.namespace());
    }

    public static void checkRole(NameIdentifier ident) {
        NameIdentifier.check((ident != null ? 1 : 0) != 0, (String)"Role identifier must not be null", (Object[])new Object[0]);
        AuthorizationUtils.checkRoleNamespace(ident.namespace());
    }

    public static void checkUserNamespace(Namespace namespace) {
        Namespace.check((namespace != null && namespace.length() == 3 ? 1 : 0) != 0, (String)"User namespace must have 3 levels, the input namespace is %s", (Object[])new Object[]{namespace});
    }

    public static void checkGroupNamespace(Namespace namespace) {
        Namespace.check((namespace != null && namespace.length() == 3 ? 1 : 0) != 0, (String)"Group namespace must have 3 levels, the input namespace is %s", (Object[])new Object[]{namespace});
    }

    public static void checkRoleNamespace(Namespace namespace) {
        Namespace.check((namespace != null && namespace.length() == 3 ? 1 : 0) != 0, (String)"Role namespace must have 3 levels, the input namespace is %s", (Object[])new Object[]{namespace});
    }

    public static void callAuthorizationPluginForSecurableObjects(String metalake, List<SecurableObject> securableObjects, Set<String> catalogsAlreadySet, Consumer<AuthorizationPlugin> consumer) {
        CatalogManager catalogManager = GravitinoEnv.getInstance().catalogManager();
        for (SecurableObject securableObject : securableObjects) {
            NameIdentifier catalogIdent;
            Catalog catalog;
            if (AuthorizationUtils.needApplyAuthorizationPluginAllCatalogs(securableObject)) {
                Catalog[] catalogs;
                for (Catalog catalog2 : catalogs = catalogManager.listCatalogsInfo(Namespace.of((String[])new String[]{metalake}))) {
                    AuthorizationUtils.callAuthorizationPluginImpl(consumer, catalog2);
                }
                continue;
            }
            if (!AuthorizationUtils.needApplyAuthorization(securableObject.type()) || catalogsAlreadySet.contains((catalog = catalogManager.loadCatalog(catalogIdent = NameIdentifierUtil.getCatalogIdentifier(MetadataObjectUtil.toEntityIdent(metalake, (MetadataObject)securableObject)))).name())) continue;
            catalogsAlreadySet.add(catalog.name());
            AuthorizationUtils.callAuthorizationPluginImpl(consumer, catalog);
        }
    }

    public static void callAuthorizationPluginForMetadataObject(String metalake, MetadataObject metadataObject, Consumer<AuthorizationPlugin> consumer) {
        CatalogManager catalogManager = GravitinoEnv.getInstance().catalogManager();
        if (AuthorizationUtils.needApplyAuthorizationPluginAllCatalogs(metadataObject.type())) {
            Catalog[] catalogs;
            for (Catalog catalog : catalogs = catalogManager.listCatalogsInfo(Namespace.of((String[])new String[]{metalake}))) {
                AuthorizationUtils.callAuthorizationPluginImpl(consumer, catalog);
            }
        } else if (AuthorizationUtils.needApplyAuthorization(metadataObject.type())) {
            NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(MetadataObjectUtil.toEntityIdent(metalake, metadataObject));
            Catalog catalog = catalogManager.loadCatalog(catalogIdent);
            AuthorizationUtils.callAuthorizationPluginImpl(consumer, catalog);
        }
    }

    private static void callAuthorizationPluginImpl(Consumer<AuthorizationPlugin> consumer, Catalog catalog) {
        BaseCatalog baseCatalog;
        if (catalog instanceof BaseCatalog && (baseCatalog = (BaseCatalog)catalog).getAuthorizationPlugin() != null) {
            consumer.accept(baseCatalog.getAuthorizationPlugin());
        }
    }

    public static boolean needApplyAuthorizationPluginAllCatalogs(SecurableObject securableObject) {
        if (securableObject.type() == MetadataObject.Type.METALAKE) {
            List privileges = securableObject.privileges();
            for (Privilege privilege : privileges) {
                if (pluginNotSupportsPrivileges.contains(privilege.name())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean needApplyAuthorizationPluginAllCatalogs(MetadataObject.Type type) {
        return type == MetadataObject.Type.METALAKE;
    }

    private static boolean needApplyAuthorization(MetadataObject.Type type) {
        return type != MetadataObject.Type.ROLE && type != MetadataObject.Type.METALAKE;
    }
}

