/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.authorization;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.authorization.AccessControlDispatcher;
import org.apache.gravitino.authorization.Group;
import org.apache.gravitino.authorization.PermissionManager;
import org.apache.gravitino.authorization.Role;
import org.apache.gravitino.authorization.RoleManager;
import org.apache.gravitino.authorization.SecurableObject;
import org.apache.gravitino.authorization.User;
import org.apache.gravitino.authorization.UserGroupManager;
import org.apache.gravitino.exceptions.GroupAlreadyExistsException;
import org.apache.gravitino.exceptions.NoSuchGroupException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchRoleException;
import org.apache.gravitino.exceptions.NoSuchUserException;
import org.apache.gravitino.exceptions.RoleAlreadyExistsException;
import org.apache.gravitino.exceptions.UserAlreadyExistsException;
import org.apache.gravitino.storage.IdGenerator;

public class AccessControlManager
implements AccessControlDispatcher {
    private final UserGroupManager userGroupManager;
    private final RoleManager roleManager;
    private final PermissionManager permissionManager;
    private final List<String> serviceAdmins;

    public AccessControlManager(EntityStore store, IdGenerator idGenerator, Config config) {
        this.roleManager = new RoleManager(store, idGenerator, config);
        this.userGroupManager = new UserGroupManager(store, idGenerator);
        this.permissionManager = new PermissionManager(store, this.roleManager);
        this.serviceAdmins = config.get(Configs.SERVICE_ADMINS);
    }

    @Override
    public User addUser(String metalake, String user) throws UserAlreadyExistsException, NoSuchMetalakeException {
        return this.userGroupManager.addUser(metalake, user);
    }

    @Override
    public boolean removeUser(String metalake, String user) throws NoSuchMetalakeException {
        return this.userGroupManager.removeUser(metalake, user);
    }

    @Override
    public User getUser(String metalake, String user) throws NoSuchUserException, NoSuchMetalakeException {
        return this.userGroupManager.getUser(metalake, user);
    }

    @Override
    public Group addGroup(String metalake, String group) throws GroupAlreadyExistsException, NoSuchMetalakeException {
        return this.userGroupManager.addGroup(metalake, group);
    }

    @Override
    public boolean removeGroup(String metalake, String group) throws NoSuchMetalakeException {
        return this.userGroupManager.removeGroup(metalake, group);
    }

    @Override
    public Group getGroup(String metalake, String group) throws NoSuchGroupException, NoSuchMetalakeException {
        return this.userGroupManager.getGroup(metalake, group);
    }

    @Override
    public User grantRolesToUser(String metalake, List<String> roles, String user) throws NoSuchUserException, NoSuchRoleException, NoSuchMetalakeException {
        return this.permissionManager.grantRolesToUser(metalake, roles, user);
    }

    @Override
    public Group grantRolesToGroup(String metalake, List<String> roles, String group) throws NoSuchGroupException, NoSuchRoleException, NoSuchMetalakeException {
        return this.permissionManager.grantRolesToGroup(metalake, roles, group);
    }

    @Override
    public Group revokeRolesFromGroup(String metalake, List<String> roles, String group) throws NoSuchGroupException, NoSuchRoleException, NoSuchMetalakeException {
        return this.permissionManager.revokeRolesFromGroup(metalake, roles, group);
    }

    @Override
    public User revokeRolesFromUser(String metalake, List<String> roles, String user) throws NoSuchUserException, NoSuchRoleException, NoSuchMetalakeException {
        return this.permissionManager.revokeRolesFromUser(metalake, roles, user);
    }

    @Override
    public boolean isServiceAdmin(String user) {
        return this.serviceAdmins.contains(user);
    }

    @Override
    public Role createRole(String metalake, String role, Map<String, String> properties, List<SecurableObject> securableObjects) throws RoleAlreadyExistsException, NoSuchMetalakeException {
        return this.roleManager.createRole(metalake, role, properties, securableObjects);
    }

    @Override
    public Role getRole(String metalake, String role) throws NoSuchRoleException, NoSuchMetalakeException {
        return this.roleManager.getRole(metalake, role);
    }

    @Override
    public boolean deleteRole(String metalake, String role) throws NoSuchMetalakeException {
        return this.roleManager.deleteRole(metalake, role);
    }

    @VisibleForTesting
    RoleManager getRoleManager() {
        return this.roleManager;
    }
}

