/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.geaflow.dsl.udf.string;

import org.apache.geaflow.common.binary.BinaryString;
import org.apache.geaflow.dsl.udf.table.string.LTrim;
import org.apache.geaflow.dsl.udf.table.string.RTrim;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TrimTest {

    @Test
    public void testLTrim() {
        LTrim lTrim = new LTrim();
        Assert.assertEquals(lTrim.eval(BinaryString.fromString(" abc")), BinaryString.fromString("abc"));
        Assert.assertEquals(lTrim.eval(BinaryString.fromString("abc")), BinaryString.fromString("abc"));
        Assert.assertEquals(lTrim.eval(BinaryString.fromString("  abc")), BinaryString.fromString("abc"));
        Assert.assertEquals(lTrim.eval(BinaryString.fromString("  ")), BinaryString.fromString(""));
    }

    @Test
    public void testRLTrim() {
        RTrim rTrim = new RTrim();
        Assert.assertEquals(rTrim.eval(BinaryString.fromString(" abc ")), BinaryString.fromString(" abc"));
        Assert.assertEquals(rTrim.eval(BinaryString.fromString("abc  ")), BinaryString.fromString("abc"));
        Assert.assertEquals(rTrim.eval(BinaryString.fromString("  ")), BinaryString.fromString(""));
    }
}
