/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.nio.file.Path;
import javax.sql.DataSource;
import org.apache.baremaps.feature.ReadableFeatureSet;
import org.apache.baremaps.feature.Resource;
import org.apache.baremaps.openstreetmap.utils.ProjectionTransformer;
import org.apache.baremaps.storage.FeatureSetProjectionTransform;
import org.apache.baremaps.storage.geopackage.GeoPackageDatabase;
import org.apache.baremaps.storage.postgres.PostgresDatabase;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.WorkflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record ImportGeoPackage(Path file, String database, Integer sourceSRID, Integer targetSRID) implements Task
{
    private static final Logger logger = LoggerFactory.getLogger(ImportGeoPackage.class);

    @Override
    public void execute(WorkflowContext context) throws Exception {
        logger.info("Importing {} into {}", (Object)this.file, (Object)this.database);
        Path path = this.file.toAbsolutePath();
        try (GeoPackageDatabase geoPackageStore = new GeoPackageDatabase(path);){
            DataSource dataSource = context.getDataSource(this.database);
            PostgresDatabase postgresDatabase = new PostgresDatabase(dataSource);
            for (Resource resource : geoPackageStore.read().toList()) {
                if (!(resource instanceof ReadableFeatureSet)) continue;
                ReadableFeatureSet featureSet = (ReadableFeatureSet)resource;
                ProjectionTransformer transformer = new ProjectionTransformer(this.sourceSRID, this.targetSRID);
                FeatureSetProjectionTransform transformedFeatureSet = new FeatureSetProjectionTransform(featureSet, transformer);
                postgresDatabase.write(transformedFeatureSet);
            }
            logger.info("Finished importing {} into {}", (Object)this.file, (Object)this.database);
        }
        catch (Exception e) {
            logger.error("Failed importing {} into {}", (Object)this.file, (Object)this.database);
            throw new WorkflowException(e);
        }
    }
}

