/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage.shapefile.internal;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ShapeType {
    NullShape(0),
    Point(1),
    PolyLine(3),
    Polygon(5),
    MultiPoint(8),
    PointZ(11),
    PolyLineZ(13),
    PolygonZ(15),
    MultiPointZ(18),
    PointM(21),
    PolyLineM(23),
    PolygonM(25),
    MultiPointM(28),
    MultiPatch(31);

    private int value;
    private static final Map<Integer, ShapeType> lookup;

    private ShapeType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ShapeType get(int value) {
        return lookup.get(value);
    }

    static {
        lookup = new HashMap<Integer, ShapeType>();
        for (ShapeType ste : EnumSet.allOf(ShapeType.class)) {
            lookup.put(ste.getValue(), ste);
        }
    }
}

