/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage.shapefile.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Objects;

public abstract class CommonByteReader
implements AutoCloseable {
    private File file;
    private FileInputStream fis;
    private FileChannel fc;
    private MappedByteBuffer byteBuffer;
    private boolean isClosed = false;

    public CommonByteReader(File f) throws IOException {
        Objects.requireNonNull(f, "The file cannot be null.");
        this.file = f;
        this.fis = new FileInputStream(this.file);
        this.fc = this.fis.getChannel();
        int fsize = (int)this.fc.size();
        this.byteBuffer = this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, fsize);
    }

    @Override
    public void close() throws IOException {
        if (this.fc != null) {
            this.fc.close();
        }
        if (this.fis != null) {
            this.fis.close();
        }
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public MappedByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public File getFile() {
        return this.file;
    }
}

