/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage;

import java.io.IOException;
import java.util.stream.Stream;
import org.apache.baremaps.feature.Feature;
import org.apache.baremaps.feature.FeatureType;
import org.apache.baremaps.feature.PropertyType;
import org.apache.baremaps.feature.ReadableFeatureSet;
import org.apache.baremaps.openstreetmap.utils.ProjectionTransformer;
import org.locationtech.jts.geom.Geometry;

public class FeatureSetProjectionTransform
implements ReadableFeatureSet {
    private final ReadableFeatureSet featureSetReader;
    private final ProjectionTransformer projectionTransformer;

    public FeatureSetProjectionTransform(ReadableFeatureSet featureSetReader, ProjectionTransformer projectionTransformer) {
        this.featureSetReader = featureSetReader;
        this.projectionTransformer = projectionTransformer;
    }

    @Override
    public FeatureType getType() throws IOException {
        return this.featureSetReader.getType();
    }

    public Stream<Feature> read() throws IOException {
        return this.featureSetReader.read().map(this::transformProjection);
    }

    public Feature transformProjection(Feature feature) {
        for (PropertyType property : feature.getType().getProperties().values()) {
            String name = property.getName();
            Object value = feature.getProperty(name);
            if (!(value instanceof Geometry)) continue;
            Geometry geometry = (Geometry)value;
            Geometry projectedGeometry = this.projectionTransformer.transform(geometry);
            feature.setProperty(name, projectedGeometry);
        }
        return feature;
    }
}

