/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.feature;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.baremaps.feature.Feature;
import org.apache.baremaps.feature.FeatureType;
import org.apache.baremaps.feature.PropertyType;

public class ReflectiveFeatureAdapter
implements Feature {
    private final Object feature;

    public ReflectiveFeatureAdapter(Object feature) {
        this.feature = feature;
    }

    @Override
    public FeatureType getType() {
        Class<?> type = this.feature.getClass();
        String name = type.getSimpleName();
        Field[] fields = type.getDeclaredFields();
        HashMap<String, PropertyType> properties = new HashMap<String, PropertyType>();
        for (Field field : fields) {
            field.setAccessible(true);
            String propertyName = field.getName();
            PropertyType propertyType = new PropertyType(propertyName, field.getType());
            properties.put(propertyName, propertyType);
        }
        return new FeatureType(name, properties);
    }

    @Override
    public Object getProperty(String name) {
        try {
            Field field = this.getClass().getDeclaredField(name);
            field.setAccessible(true);
            return field.get(this);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void setProperty(String name, Object value) throws IllegalArgumentException {
        try {
            Field field = this.getClass().getDeclaredField(name);
            field.setAccessible(true);
            field.set(this, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public Map<String, Object> getProperties() {
        Class<?> type = this.feature.getClass();
        Field[] fields = type.getDeclaredFields();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (Field field : fields) {
            field.setAccessible(true);
            String propertyName = field.getName();
            try {
                Object propertyValue = field.get(this);
                properties.put(propertyName, propertyValue);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return properties;
    }
}

