/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.tile;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.SelectItem;

class PostgresGroup {
    private final List<SelectItem> selectItems;
    private final FromItem fromItem;
    private final List<Join> joins;

    public PostgresGroup(List<SelectItem> selectItems, FromItem fromItem, List<Join> joins) {
        this.selectItems = selectItems;
        this.fromItem = fromItem;
        this.joins = joins;
    }

    public List<SelectItem> getSelectItems() {
        return this.selectItems;
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public String getAlias() {
        return String.format("h%x", this.hashCode());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PostgresGroup)) {
            return false;
        }
        return this.hashCode() == o.hashCode();
    }

    public int hashCode() {
        String selectItemsString = this.selectItems.toString();
        String fromItemString = this.fromItem.toString();
        String joinsString = Optional.ofNullable(this.joins).stream().flatMap(Collection::stream).map(Join::toString).collect(Collectors.joining());
        return Objects.hash(selectItemsString, fromItemString, joinsString);
    }
}

