/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database;

import java.util.function.Consumer;
import org.apache.baremaps.database.repository.Repository;
import org.apache.baremaps.database.repository.RepositoryException;
import org.apache.baremaps.openstreetmap.model.Change;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.stream.StreamException;

public class ChangeImporter
implements Consumer<Change> {
    private final Repository<Long, Node> nodeRepository;
    private final Repository<Long, Way> wayRepository;
    private final Repository<Long, Relation> relationRepository;

    public ChangeImporter(Repository<Long, Node> nodeRepository, Repository<Long, Way> wayRepository, Repository<Long, Relation> relationRepository) {
        this.nodeRepository = nodeRepository;
        this.wayRepository = wayRepository;
        this.relationRepository = relationRepository;
    }

    @Override
    public void accept(Change change) {
        try {
            block6: for (Entity entity : change.getEntities()) {
                switch (change.getType()) {
                    case CREATE: 
                    case MODIFY: {
                        Way way;
                        Node node;
                        if (entity instanceof Node) {
                            node = (Node)entity;
                            this.nodeRepository.put(node);
                            break;
                        }
                        if (entity instanceof Way) {
                            way = (Way)entity;
                            this.wayRepository.put(way);
                            break;
                        }
                        if (!(entity instanceof Relation)) continue block6;
                        Relation relation = (Relation)entity;
                        this.relationRepository.put(relation);
                        break;
                    }
                    case DELETE: {
                        Way way;
                        Node node;
                        if (entity instanceof Node) {
                            node = (Node)entity;
                            this.nodeRepository.delete(node.id());
                            break;
                        }
                        if (entity instanceof Way) {
                            way = (Way)entity;
                            this.wayRepository.delete(way.id());
                            break;
                        }
                        if (!(entity instanceof Relation)) break;
                        Relation relation = (Relation)entity;
                        this.relationRepository.delete(relation.id());
                    }
                }
            }
        }
        catch (RepositoryException e) {
            throw new StreamException(e);
        }
    }
}

