/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.collection.type;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.collection.type.DataType;

public class ShortListDataType
implements DataType<List<Short>> {
    @Override
    public int size(List<Short> values) {
        return 4 + values.size() * 2;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, List<Short> values) {
        buffer.putInt(position, this.size(values));
        position += 4;
        for (Short value : values) {
            buffer.putShort(position, value);
            position += 2;
        }
    }

    @Override
    public List<Short> read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        ArrayList<Short> list = new ArrayList<Short>(size);
        for (int p = position + 4; p < position + size; p += 2) {
            list.add(buffer.getShort(p));
        }
        return list;
    }
}

