/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.collection.type;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.baremaps.collection.type.FixedSizeDataType;

public class PairDataType<L, R>
extends FixedSizeDataType<Pair<L, R>> {
    private final FixedSizeDataType<L> left;
    private final FixedSizeDataType<R> right;

    public PairDataType(FixedSizeDataType<L> left, FixedSizeDataType<R> right) {
        super(left.size() + right.size());
        this.left = left;
        this.right = right;
    }

    @Override
    public void write(ByteBuffer buffer, int position, Pair<L, R> value) {
        this.left.write(buffer, position, value.left());
        this.right.write(buffer, position + this.left.size(), value.right());
    }

    @Override
    public Pair<L, R> read(ByteBuffer buffer, int position) {
        return new Pair(this.left.read(buffer, position), this.right.read(buffer, position + this.left.size()));
    }

    public static class Pair<L, R> {
        private final L left;
        private final R right;

        public Pair(L left, R right) {
            this.left = left;
            this.right = right;
        }

        public L left() {
            return this.left;
        }

        public R right() {
            return this.right;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair pair = (Pair)o;
            if (!Objects.equals(this.left, pair.left)) {
                return false;
            }
            return Objects.equals(this.right, pair.right);
        }

        public int hashCode() {
            int result = this.left != null ? this.left.hashCode() : 0;
            result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
            return result;
        }
    }
}

