/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.collection.type;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.collection.type.DataType;

public class ListDataType<T>
implements DataType<List<T>> {
    public final DataType<T> dataType;

    public ListDataType(DataType<T> dataType) {
        this.dataType = dataType;
    }

    @Override
    public int size(List<T> values) {
        int size = 4;
        for (T value : values) {
            size += this.dataType.size(value);
        }
        return size;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, List<T> values) {
        buffer.putInt(position, this.size(values));
        position += 4;
        for (T value : values) {
            this.dataType.write(buffer, position, value);
            position += this.dataType.size(value);
        }
    }

    @Override
    public List<T> read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        ArrayList<T> list = new ArrayList<T>(size);
        for (int p = position + 4; p < position + size; p += this.dataType.size(buffer, p)) {
            list.add(this.dataType.read(buffer, p));
        }
        return list;
    }
}

