/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.collection.algorithm;

import java.util.Comparator;
import java.util.function.Function;
import org.apache.baremaps.collection.DataList;

public class BinarySearch {
    public static <E> Long binarySearch(DataList<E> list, E value, Comparator<E> comparator) {
        return BinarySearch.binarySearch(list, value, comparator, 0L, list.sizeAsLong() - 1L);
    }

    public static <E> Long binarySearch(DataList<E> list, E value, Comparator<E> comparator, long fromIndex, long toIndex) {
        long lo = fromIndex;
        long hi = toIndex;
        while (lo <= hi) {
            long mi = lo + hi >>> 1;
            E e = list.get(mi);
            int cmp = comparator.compare(e, value);
            if (cmp < 0) {
                lo = mi + 1L;
                continue;
            }
            if (cmp > 0) {
                hi = mi - 1L;
                continue;
            }
            return mi;
        }
        return null;
    }

    public static <E, A> E binarySearchAttribute(DataList<E> list, Function<E, A> extractor, A value, Comparator<A> comparator) {
        long lo = 0L;
        long hi = list.sizeAsLong() - 1L;
        while (lo <= hi) {
            long mi = lo + hi >>> 1;
            E e = list.get(mi);
            A a = extractor.apply(e);
            int cmp = comparator.compare(a, value);
            if (cmp < 0) {
                lo = mi + 1L;
                continue;
            }
            if (cmp > 0) {
                hi = mi - 1L;
                continue;
            }
            return e;
        }
        return null;
    }

    public static <E, A> E binarySearchAttribute(DataList<E> list, Function<E, A> extractor, A value, Comparator<A> comparator, long fromIndex, long toIndex) {
        long lo = fromIndex;
        long hi = toIndex;
        while (lo <= hi) {
            long mi = lo + hi >>> 1;
            E e = list.get(mi);
            A a = extractor.apply(e);
            int cmp = comparator.compare(a, value);
            if (cmp < 0) {
                lo = mi + 1L;
                continue;
            }
            if (cmp > 0) {
                hi = mi - 1L;
                continue;
            }
            return e;
        }
        return null;
    }
}

