/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.collection;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.baremaps.collection.DataCollectionException;
import org.apache.baremaps.collection.DataList;
import org.apache.baremaps.collection.memory.Memory;
import org.apache.baremaps.collection.memory.OffHeapMemory;
import org.apache.baremaps.collection.type.FixedSizeDataType;

public class FixedSizeDataList<E>
extends DataList<E> {
    private final FixedSizeDataType<E> dataType;
    private final Memory memory;
    private AtomicLong size;

    public FixedSizeDataList(FixedSizeDataType<E> dataType) {
        this(dataType, new OffHeapMemory());
    }

    public FixedSizeDataList(FixedSizeDataType<E> dataType, Memory memory) {
        if (dataType.size() > memory.segmentSize()) {
            throw new DataCollectionException("The segment size is too small for the data type");
        }
        this.dataType = dataType;
        this.memory = memory;
        this.size = new AtomicLong(0L);
    }

    private void write(long index, E value) {
        long position = index * (long)this.dataType.size();
        int segmentIndex = (int)(position / (long)this.dataType.size());
        int segmentOffset = (int)(position % (long)this.dataType.size());
        ByteBuffer segment = this.memory.segment(segmentIndex);
        this.dataType.write(segment, segmentOffset, value);
    }

    @Override
    public long addIndexed(E value) {
        long index = this.size.getAndIncrement();
        this.write(index, value);
        return index;
    }

    @Override
    public void set(long index, E value) {
        if (index >= this.sizeAsLong()) {
            throw new IndexOutOfBoundsException();
        }
        this.write(index, value);
    }

    @Override
    public E get(long index) {
        long position = index * (long)this.dataType.size();
        int segmentIndex = (int)(position / (long)this.dataType.size());
        int segmentOffset = (int)(position % (long)this.dataType.size());
        ByteBuffer segment = this.memory.segment(segmentIndex);
        return (E)this.dataType.read(segment, segmentOffset);
    }

    @Override
    public long sizeAsLong() {
        return this.size.get();
    }

    @Override
    public void clear() {
        try {
            this.size.set(0L);
            this.memory.clear();
        }
        catch (IOException e) {
            throw new DataCollectionException(e);
        }
    }
}

