/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.sql.DataSource;
import javax.ws.rs.core.Response;
import org.apache.baremaps.api.TilesetsApi;
import org.apache.baremaps.database.tile.PostgresQuery;
import org.apache.baremaps.database.tile.PostgresTileStore;
import org.apache.baremaps.database.tile.Tile;
import org.apache.baremaps.database.tile.TileStore;
import org.apache.baremaps.database.tile.TileStoreException;
import org.apache.baremaps.model.TileJSON;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.json.Json;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TilesetsResource
implements TilesetsApi {
    private static final Logger logger = LoggerFactory.getLogger(TilesetsResource.class);
    private static final QualifiedType<TileJSON> TILESET = QualifiedType.of(TileJSON.class).with(new Class[]{Json.class});
    private final DataSource dataSource;
    private final Jdbi jdbi;
    private final LoadingCache<UUID, TileStore> tileStores = Caffeine.newBuilder().build(this::loadTileStore);

    @Inject
    public TilesetsResource(DataSource dataSource, Jdbi jdbi) {
        this.dataSource = dataSource;
        this.jdbi = jdbi;
    }

    private TileStore loadTileStore(UUID tilesetId) {
        TileJSON tileset = (TileJSON)this.jdbi.withHandle(handle -> (TileJSON)((Query)handle.createQuery("select tileset from tilesets where id = :id").bind("id", tilesetId)).mapTo(TILESET).one());
        List queries = tileset.getVectorLayers().stream().flatMap(layer -> layer.getQueries().stream().map(query -> new PostgresQuery(layer.getId(), query.getMinzoom(), query.getMaxzoom(), query.getSql()))).toList();
        return new PostgresTileStore(this.dataSource, queries);
    }

    @Override
    public Response addTileset(TileJSON tileSet) {
        UUID tilesetId;
        try {
            tilesetId = UUID.fromString(tileSet.getTiles().get(0).split("/")[4]);
        }
        catch (Exception e) {
            tilesetId = UUID.randomUUID();
        }
        UUID finalTilesetId = tilesetId;
        this.jdbi.useHandle(handle -> ((Update)((Update)handle.createUpdate("insert into tilesets (id, tileset) values (:id, CAST(:json AS JSONB))").bindByType("json", (Object)tileSet, TILESET)).bind("id", finalTilesetId)).execute());
        return Response.created((URI)URI.create("tilesets/" + tilesetId)).build();
    }

    @Override
    public Response deleteTileset(UUID tilesetId) {
        this.tileStores.invalidate((Object)tilesetId);
        this.jdbi.useHandle(handle -> handle.execute("delete from tilesets where id = (?)", new Object[]{tilesetId}));
        return Response.noContent().build();
    }

    @Override
    public Response getTileset(UUID tilesetId) {
        TileJSON tileset = (TileJSON)this.jdbi.withHandle(handle -> (TileJSON)((Query)handle.createQuery("select tileset from tilesets where id = :id").bind("id", tilesetId)).mapTo(TILESET).one());
        return Response.ok((Object)tileset).build();
    }

    @Override
    public Response getTilesets() {
        List ids = (List)this.jdbi.withHandle(handle -> handle.createQuery("select id from tilesets").mapTo(UUID.class).list());
        return Response.ok((Object)ids).build();
    }

    @Override
    public Response updateTileset(UUID tilesetId, TileJSON tileSet) {
        this.tileStores.invalidate((Object)tilesetId);
        this.jdbi.useHandle(handle -> ((Update)((Update)handle.createUpdate("update tilesets set tileset = cast(:json as jsonb) where id = :id").bindByType("json", (Object)tileSet, TILESET)).bind("id", tilesetId)).execute());
        return Response.noContent().build();
    }

    @Override
    public Response getTile(UUID tilesetId, String tileMatrixSetId, Integer tileMatrix, Integer tileRow, Integer tileCol) {
        Tile tile = new Tile(tileCol.intValue(), tileRow.intValue(), tileMatrix.intValue());
        TileStore tileStore = (TileStore)this.tileStores.get((Object)tilesetId);
        try {
            return Response.ok((Object)tileStore.read(tile)).header("Content-Encoding", (Object)"gzip").build();
        }
        catch (TileStoreException e) {
            return Response.serverError().build();
        }
    }
}

