/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.baremaps.model.Link;

public class LandingPage {
    @Valid
    private String title;
    @Valid
    private String description;
    @Valid
    private List<Link> links = new ArrayList<Link>();

    public LandingPage title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="Buildings in Bonn", value="")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public LandingPage description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Access to data about buildings in the city of Bonn via a Web API that conforms to the OGC API Features specification.", value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LandingPage links(List<Link> links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="links")
    @NotNull
    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LandingPage landingPage = (LandingPage)o;
        return Objects.equals(this.title, landingPage.title) && Objects.equals(this.description, landingPage.description) && Objects.equals(this.links, landingPage.links);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LandingPage {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

