/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.baremaps.model.Extent;
import org.apache.baremaps.model.Link;

public class Collection {
    @Valid
    private UUID id;
    @Valid
    private String title;
    @Valid
    private String description;
    @Valid
    private String attribution;
    @Valid
    private List<Link> links = new ArrayList<Link>();
    @Valid
    private Extent extent;
    @Valid
    private String itemType;
    @Valid
    private List<String> crs = new ArrayList<String>();
    @Valid
    private Date created;
    @Valid
    private Integer count;
    @Valid
    private String geometryType;

    public Collection id(UUID id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="id")
    @NotNull
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Collection title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="address", value="")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Collection description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="An address", value="")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Collection attribution(String attribution) {
        this.attribution = attribution;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="attribution")
    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public Collection links(List<Link> links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="links")
    @NotNull
    public List<Link> getLinks() {
        return this.links;
    }

    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public Collection extent(Extent extent) {
        this.extent = extent;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="extent")
    public Extent getExtent() {
        return this.extent;
    }

    public void setExtent(Extent extent) {
        this.extent = extent;
    }

    public Collection itemType(String itemType) {
        this.itemType = itemType;
        return this;
    }

    @ApiModelProperty(value="An indicator about the type of the items in the collection")
    @JsonProperty(value="itemType")
    public String getItemType() {
        return this.itemType;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public Collection crs(List<String> crs) {
        this.crs = crs;
        return this;
    }

    @ApiModelProperty(example="[http://www.opengis.net/def/crs/OGC/1.3/CRS84, http://www.opengis.net/def/crs/EPSG/0/4326]", value="the list of coordinate reference systems supported by the API; the first item is the default coordinate reference system")
    @JsonProperty(value="crs")
    public List<String> getCrs() {
        return this.crs;
    }

    public void setCrs(List<String> crs) {
        this.crs = crs;
    }

    public Collection created(Date created) {
        this.created = created;
        return this;
    }

    @ApiModelProperty(value="Date of creation")
    @JsonProperty(value="created")
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Collection count(Integer count) {
        this.count = count;
        return this;
    }

    @ApiModelProperty(value="Feature count")
    @JsonProperty(value="count")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Collection geometryType(String geometryType) {
        this.geometryType = geometryType;
        return this;
    }

    @ApiModelProperty(value="Geometry type of the features")
    @JsonProperty(value="geometryType")
    public String getGeometryType() {
        return this.geometryType;
    }

    public void setGeometryType(String geometryType) {
        this.geometryType = geometryType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Collection collection = (Collection)o;
        return Objects.equals(this.id, collection.id) && Objects.equals(this.title, collection.title) && Objects.equals(this.description, collection.description) && Objects.equals(this.attribution, collection.attribution) && Objects.equals(this.links, collection.links) && Objects.equals(this.extent, collection.extent) && Objects.equals(this.itemType, collection.itemType) && Objects.equals(this.crs, collection.crs) && Objects.equals(this.created, collection.created) && Objects.equals(this.count, collection.count) && Objects.equals(this.geometryType, collection.geometryType);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.description, this.attribution, this.links, this.extent, this.itemType, this.crs, this.created, this.count, this.geometryType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Collection {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    attribution: ").append(this.toIndentedString(this.attribution)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    extent: ").append(this.toIndentedString(this.extent)).append("\n");
        sb.append("    itemType: ").append(this.toIndentedString(this.itemType)).append("\n");
        sb.append("    crs: ").append(this.toIndentedString(this.crs)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    geometryType: ").append(this.toIndentedString(this.geometryType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

