/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.uritemplate.render;

import com.github.fge.uritemplate.URITemplateException;
import com.github.fge.uritemplate.expression.ExpressionType;
import com.github.fge.uritemplate.render.ValueRenderer;
import com.github.fge.uritemplate.vars.specs.VariableSpec;
import com.github.fge.uritemplate.vars.values.VariableValue;
import com.google.common.collect.ImmutableList;
import java.util.List;

public final class StringRenderer
extends ValueRenderer {
    public StringRenderer(ExpressionType type) {
        super(type);
    }

    @Override
    public List<String> render(VariableSpec varspec, VariableValue value) throws URITemplateException {
        return ImmutableList.of((Object)this.doRender(varspec, value.getScalarValue()));
    }

    private String doRender(VariableSpec varspec, String value) {
        int prefixLen;
        StringBuilder sb = new StringBuilder(value.length());
        if (this.named) {
            sb.append(varspec.getName());
            if (value.isEmpty()) {
                return sb.append(this.ifEmpty).toString();
            }
            sb.append('=');
        }
        if ((prefixLen = varspec.getPrefixLength()) == -1) {
            return sb.append(this.pctEncode(value)).toString();
        }
        int len = value.codePointCount(0, value.length());
        return len <= prefixLen ? sb.append(this.pctEncode(value)).toString() : sb.append(this.pctEncode(StringRenderer.nFirstChars(value, prefixLen))).toString();
    }

    private static String nFirstChars(String s, int n) {
        int realIndex = n;
        while (s.codePointCount(0, realIndex) != n) {
            ++realIndex;
        }
        return s.substring(0, realIndex);
    }
}

