/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=IteratorValueNode.class)
public final class IteratorValueNodeGen
extends IteratorValueNode
implements Introspection.Provider {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    @CompilerDirectives.CompilationFinal
    private volatile int state_0_;
    @CompilerDirectives.CompilationFinal
    private volatile int exclude_;
    @Node.Child
    private ForeignObject0Data foreignObject0_cache;
    @Node.Child
    private ImportValueNode foreignObject1_importValueNode_;

    private IteratorValueNodeGen(JSContext context, JavaScriptNode iterResultNode) {
        super(context, iterResultNode);
    }

    @Override
    @ExplodeLoop
    public Object execute(Object iterResultNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0 && iterResultNodeValue instanceof JSDynamicObject) {
            JSDynamicObject iterResultNodeValue_ = (JSDynamicObject)((Object)iterResultNodeValue);
            return this.doIteratorNext(iterResultNodeValue_);
        }
        if ((state_0 & 6) != 0) {
            if ((state_0 & 2) != 0) {
                ForeignObject0Data s1_ = this.foreignObject0_cache;
                while (s1_ != null) {
                    if (s1_.interop_.accepts(iterResultNodeValue) && JSGuards.isForeignObject(iterResultNodeValue)) {
                        return this.doForeignObject(iterResultNodeValue, s1_.interop_, s1_.importValueNode_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 4) != 0 && JSGuards.isForeignObject(iterResultNodeValue)) {
                return this.foreignObject1Boundary(state_0, iterResultNodeValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(iterResultNodeValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object foreignObject1Boundary(int state_0, Object iterResultNodeValue) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary foreignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(iterResultNodeValue);
            Object object = this.doForeignObject(iterResultNodeValue, foreignObject1_interop__, this.foreignObject1_importValueNode_);
            return object;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object iterResultNodeValue_ = this.iterResultNode.execute(frameValue);
        if ((state_0 & 1) != 0 && iterResultNodeValue_ instanceof JSDynamicObject) {
            JSDynamicObject iterResultNodeValue__ = (JSDynamicObject)((Object)iterResultNodeValue_);
            return this.doIteratorNext(iterResultNodeValue__);
        }
        if ((state_0 & 6) != 0) {
            if ((state_0 & 2) != 0) {
                ForeignObject0Data s1_ = this.foreignObject0_cache;
                while (s1_ != null) {
                    if (s1_.interop_.accepts(iterResultNodeValue_) && JSGuards.isForeignObject(iterResultNodeValue_)) {
                        return this.doForeignObject(iterResultNodeValue_, s1_.interop_, s1_.importValueNode_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 4) != 0 && JSGuards.isForeignObject(iterResultNodeValue_)) {
                return this.foreignObject1Boundary0(state_0, iterResultNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(iterResultNodeValue_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    private Object foreignObject1Boundary0(int state_0, Object iterResultNodeValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set((Node)this);
        try {
            InteropLibrary foreignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(iterResultNodeValue_);
            Object object = this.doForeignObject(iterResultNodeValue_, foreignObject1_interop__, this.foreignObject1_importValueNode_);
            return object;
        }
        finally {
            encapsulating_.set(prev_);
        }
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.execute(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(Object iterResultNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        try {
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            if (iterResultNodeValue instanceof JSDynamicObject) {
                JSDynamicObject iterResultNodeValue_ = (JSDynamicObject)((Object)iterResultNodeValue);
                this.state_0_ = state_0 |= 1;
                lock.unlock();
                hasLock = false;
                Object object = this.doIteratorNext(iterResultNodeValue_);
                return object;
            }
            if (exclude == 0) {
                int count1_ = 0;
                ForeignObject0Data s1_ = this.foreignObject0_cache;
                if ((state_0 & 2) != 0) {
                    while (!(s1_ == null || s1_.interop_.accepts(iterResultNodeValue) && JSGuards.isForeignObject(iterResultNodeValue))) {
                        s1_ = s1_.next_;
                        ++count1_;
                    }
                }
                if (s1_ == null && JSGuards.isForeignObject(iterResultNodeValue) && count1_ < 5) {
                    s1_ = (ForeignObject0Data)super.insert((Node)new ForeignObject0Data(this.foreignObject0_cache));
                    s1_.interop_ = s1_.insertAccessor((InteropLibrary)INTEROP_LIBRARY_.create(iterResultNodeValue));
                    s1_.importValueNode_ = s1_.insertAccessor(ImportValueNode.create());
                    VarHandle.storeStoreFence();
                    this.foreignObject0_cache = s1_;
                    this.state_0_ = state_0 |= 2;
                }
                if (s1_ != null) {
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doForeignObject(iterResultNodeValue, s1_.interop_, s1_.importValueNode_);
                    return object;
                }
            }
            InteropLibrary foreignObject1_interop__ = null;
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set((Node)this);
            try {
                if (JSGuards.isForeignObject(iterResultNodeValue)) {
                    foreignObject1_interop__ = (InteropLibrary)INTEROP_LIBRARY_.getUncached(iterResultNodeValue);
                    this.foreignObject1_importValueNode_ = (ImportValueNode)super.insert((Node)ImportValueNode.create());
                    this.exclude_ = exclude |= 1;
                    this.foreignObject0_cache = null;
                    state_0 &= 0xFFFFFFFD;
                    this.state_0_ = state_0 |= 4;
                    lock.unlock();
                    hasLock = false;
                    Object object = this.doForeignObject(iterResultNodeValue, foreignObject1_interop__, this.foreignObject1_importValueNode_);
                    return object;
                }
            }
            finally {
                encapsulating_.set(prev_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.iterResultNode}, new Object[]{iterResultNodeValue});
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        ForeignObject0Data s1_;
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0 && ((s1_ = this.foreignObject0_cache) == null || s1_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[4];
        data[0] = 0;
        int state_0 = this.state_0_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doIteratorNext";
        s[1] = (state_0 & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state_0 & 2) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            ForeignObject0Data s1_ = this.foreignObject0_cache;
            while (s1_ != null) {
                cached.add(Arrays.asList(new Node[]{s1_.interop_, s1_.importValueNode_}));
                s1_ = s1_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = exclude != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[2] = s;
        s = new Object[3];
        s[0] = "doForeignObject";
        if ((state_0 & 4) != 0) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.foreignObject1_importValueNode_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[3] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static IteratorValueNode create(JSContext context, JavaScriptNode iterResultNode) {
        return new IteratorValueNodeGen(context, iterResultNode);
    }

    @GeneratedBy(value=IteratorValueNode.class)
    private static final class ForeignObject0Data
    extends Node {
        @Node.Child
        ForeignObject0Data next_;
        @Node.Child
        InteropLibrary interop_;
        @Node.Child
        ImportValueNode importValueNode_;

        ForeignObject0Data(ForeignObject0Data next_) {
            this.next_ = next_;
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        <T extends Node> T insertAccessor(T node) {
            return (T)super.insert(node);
        }
    }
}

