/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeSingle;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.PublishAndSubscribeOnSingles;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.context.api.ContextMap;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

final class TimeoutSingle<T>
extends AbstractNoHandleSubscribeSingle<T> {
    private final Single<T> original;
    private final Executor timeoutExecutor;
    private final long durationNs;

    TimeoutSingle(Single<T> original, Duration duration, Executor timeoutExecutor) {
        this.original = original;
        this.durationNs = duration.toNanos();
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor);
    }

    TimeoutSingle(Single<T> original, long duration, TimeUnit unit, Executor timeoutExecutor) {
        this.original = original;
        this.durationNs = unit.toNanos(duration);
        this.timeoutExecutor = Objects.requireNonNull(timeoutExecutor);
    }

    @Override
    protected void handleSubscribe(SingleSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(TimeoutSubscriber.newInstance(this, subscriber, contextMap, contextProvider), contextMap, contextProvider);
    }

    private static final class TimeoutSubscriber<X>
    implements SingleSource.Subscriber<X>,
    Cancellable {
        private static final Cancellable LOCAL_IGNORE_CANCEL = () -> {};
        private static final int STATE_ON_WAITING_FOR_SUBSCRIBE = 0;
        private static final int STATE_ON_SUBSCRIBE_DONE = 1;
        private static final int STATE_TIMED_OUT_ERROR = 2;
        private static final AtomicReferenceFieldUpdater<TimeoutSubscriber, Cancellable> cancellableUpdater = AtomicReferenceFieldUpdater.newUpdater(TimeoutSubscriber.class, Cancellable.class, "cancellable");
        private static final AtomicIntegerFieldUpdater<TimeoutSubscriber> subscriberStateUpdater = AtomicIntegerFieldUpdater.newUpdater(TimeoutSubscriber.class, "subscriberState");
        @Nullable
        private volatile Cancellable cancellable;
        private volatile int subscriberState;
        private final TimeoutSingle<X> parent;
        private final SingleSource.Subscriber<? super X> target;
        private final AsyncContextProvider contextProvider;
        @Nullable
        private Cancellable timerCancellable;

        private TimeoutSubscriber(TimeoutSingle<X> parent, SingleSource.Subscriber<? super X> target, AsyncContextProvider contextProvider) {
            this.parent = parent;
            this.target = target;
            this.contextProvider = contextProvider;
        }

        static <X> TimeoutSubscriber<X> newInstance(TimeoutSingle<X> parent, SingleSource.Subscriber<? super X> target, ContextMap contextMap, AsyncContextProvider contextProvider) {
            Cancellable localTimerCancellable;
            TimeoutSubscriber<? super X> s = new TimeoutSubscriber<X>(parent, target, contextProvider);
            try {
                localTimerCancellable = Objects.requireNonNull(parent.timeoutExecutor.schedule(s::timerFires, parent.durationNs, TimeUnit.NANOSECONDS), () -> "Executor.schedule " + parent.timeoutExecutor + " returned null");
            }
            catch (Throwable cause) {
                localTimerCancellable = IGNORE_CANCEL;
                s.cancellable = LOCAL_IGNORE_CANCEL;
                PublishAndSubscribeOnSingles.deliverOnSubscribeAndOnError(target, contextMap, contextProvider, cause);
            }
            s.timerCancellable = localTimerCancellable;
            return s;
        }

        public void onSubscribe(Cancellable cancellable) {
            if (cancellableUpdater.compareAndSet(this, null, cancellable)) {
                this.target.onSubscribe((Cancellable)this);
                if (!subscriberStateUpdater.compareAndSet(this, 0, 1)) {
                    this.target.onError((Throwable)this.newTimeoutException());
                }
            } else {
                cancellable.cancel();
            }
        }

        public void onSuccess(@Nullable X result) {
            if (cancellableUpdater.getAndSet(this, LOCAL_IGNORE_CANCEL) != LOCAL_IGNORE_CANCEL) {
                try {
                    this.stopTimer();
                }
                finally {
                    this.target.onSuccess(result);
                }
            }
        }

        public void onError(Throwable t) {
            if (cancellableUpdater.getAndSet(this, LOCAL_IGNORE_CANCEL) != LOCAL_IGNORE_CANCEL) {
                try {
                    this.stopTimer();
                }
                finally {
                    this.target.onError(t);
                }
            }
        }

        public void cancel() {
            Cancellable oldCancellable = cancellableUpdater.getAndSet(this, LOCAL_IGNORE_CANCEL);
            if (oldCancellable != LOCAL_IGNORE_CANCEL) {
                try {
                    this.stopTimer();
                }
                finally {
                    oldCancellable.cancel();
                }
            }
        }

        private void timerFires() {
            Cancellable oldCancellable = cancellableUpdater.getAndSet(this, LOCAL_IGNORE_CANCEL);
            if (oldCancellable != LOCAL_IGNORE_CANCEL) {
                SingleSource.Subscriber<? super X> offloadedTarget;
                SingleSource.Subscriber<? super X> subscriber = offloadedTarget = ((TimeoutSingle)this.parent).timeoutExecutor == Executors.immediate() ? this.target : this.contextProvider.wrapSingleSubscriber(this.target, this.contextProvider.context());
                if (oldCancellable != null) {
                    oldCancellable.cancel();
                    if (subscriberStateUpdater.getAndSet(this, 2) == 1) {
                        offloadedTarget.onError((Throwable)this.newTimeoutException());
                    }
                } else {
                    SubscriberUtils.deliverErrorFromSource(offloadedTarget, (Throwable)this.newTimeoutException());
                }
            }
        }

        private TimeoutException newTimeoutException() {
            return new TimeoutException("timeout after " + TimeUnit.NANOSECONDS.toMillis(((TimeoutSingle)this.parent).durationNs) + "ms");
        }

        private void stopTimer() {
            assert (this.timerCancellable != null);
            this.timerCancellable.cancel();
        }
    }
}

