/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractSynchronousCompletableOperator;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ComposedCancellable;
import java.util.Objects;

final class DoCancellableCompletable
extends AbstractSynchronousCompletableOperator {
    private final Cancellable cancellable;
    private final boolean before;

    DoCancellableCompletable(Completable original, Cancellable cancellable, boolean before) {
        super(original);
        this.cancellable = Objects.requireNonNull(cancellable);
        this.before = before;
    }

    @Override
    public CompletableSource.Subscriber apply(CompletableSource.Subscriber subscriber) {
        return new DoCancellableCompletableSubscriber(subscriber, this);
    }

    private static final class DoCancellableCompletableSubscriber
    implements CompletableSource.Subscriber {
        private final CompletableSource.Subscriber original;
        private final DoCancellableCompletable parent;

        DoCancellableCompletableSubscriber(CompletableSource.Subscriber original, DoCancellableCompletable parent) {
            this.original = original;
            this.parent = parent;
        }

        public void onSubscribe(Cancellable originalCancellable) {
            this.original.onSubscribe((Cancellable)(this.parent.before ? new ComposedCancellable(this.parent.cancellable, originalCancellable) : new ComposedCancellable(originalCancellable, this.parent.cancellable)));
        }

        public void onComplete() {
            this.original.onComplete();
        }

        public void onError(Throwable t) {
            this.original.onError(t);
        }
    }
}

